<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:epl="http://www.ethernet-powerlink.org" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:myFunction="http://br-automation.com/customXSLTFunctions" xmlns:saxon="http://saxon.sf.net/" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:xalan="http://xml.apache.org/xalan/java/org.apache.xalan.lib.NodeInfo" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0"><xsl:param name="archiveDirParameter"/><xsl:param name="archiveNameParameter"/><xsl:param name="fileNameParameter"/><xsl:param name="fileDirParameter"/><xsl:variable name="document-uri"><xsl:value-of select="document-uri(/)"/></xsl:variable><xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" indent="yes" method="xml" omit-xml-declaration="no" standalone="yes"/><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:double" name="myFunction:hex2dec"><xsl:param name="hex"/><xsl:choose><xsl:when test="contains(string($hex),'NaN')"><xsl:value-of select="'NaN'"/></xsl:when><xsl:when test="starts-with($hex, '0x')"><xsl:variable name="hexCorrected" select="translate($hex, 'abcdef', 'ABCDEF')"/><xsl:choose><xsl:when test="string-length($hexCorrected) = 1"><xsl:value-of select="myFunction:hexDigitToInteger($hexCorrected)"/></xsl:when><xsl:otherwise><xsl:value-of select="16 * (myFunction:hex2dec(substring($hexCorrected, 1, string-length($hexCorrected) - 1))) + myFunction:hexDigitToInteger(substring($hexCorrected, string-length($hexCorrected), 1))"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="number($hex)"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:integer" name="myFunction:hexDigitToInteger"><xsl:param as="xs:string" name="char"/><xsl:value-of select="string-length(substring-before('0123456789ABCDEF', $char))"/></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:string" name="myFunction:dec2hex"><xsl:param as="xs:double" name="dec"/><xsl:choose><xsl:when test="number($dec) &lt; 16"><xsl:value-of select="myFunction:intToHexChar(number($dec))"/></xsl:when><xsl:otherwise><xsl:value-of select="concat(myFunction:dec2hex(floor(number($dec) div 16)), myFunction:intToHexChar(number($dec) mod 16))"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:string" name="myFunction:intToHexChar"><xsl:param as="xs:double" name="in"/><xsl:variable name="hexDigits" select="'0123456789ABCDEF'"/><xsl:value-of select="substring($hexDigits, (number($in) mod 16) + 1, 1)"/></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:string" name="myFunction:dec2bin"><xsl:param as="xs:double" name="dec"/><xsl:choose><xsl:when test="contains(string($dec), 'NaN')"><xsl:value-of select="'NaN'"/></xsl:when><xsl:when test="number($dec) = 0"><xsl:value-of select="'0'"/></xsl:when><xsl:when test="number($dec) = 1"><xsl:value-of select="'1'"/></xsl:when><xsl:otherwise><xsl:value-of select="concat(myFunction:dec2bin(floor(number($dec) div 2)), myFunction:dec2bin(number($dec) mod 2))"/></xsl:otherwise></xsl:choose></xsl:function><xsl:template match="*" mode="schematron-select-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="."/></xsl:template><xsl:template match="*" mode="schematron-get-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="parent::*"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''"><xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>*:</xsl:text><xsl:value-of select="local-name()"/><xsl:text>[namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose><xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/><xsl:text>[</xsl:text><xsl:value-of select="1+ $preceding"/><xsl:text>]</xsl:text></xsl:template><xsl:template match="@*" mode="schematron-get-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="parent::*"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>@*[local-name()='</xsl:text><xsl:value-of select="local-name()"/><xsl:text>' and namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="node() | @*" mode="schematron-get-full-path-2"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><xsl:template match="node() | @*" mode="schematron-get-full-path-3"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="parent::*"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><xsl:template match="/" mode="generate-id-from-path"/><xsl:template match="text()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/></xsl:template><xsl:template match="comment()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/></xsl:template><xsl:template match="processing-instruction()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/></xsl:template><xsl:template match="@*" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.@', name())"/></xsl:template><xsl:template match="*" mode="generate-id-from-path" priority="-0.5"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:text>.</xsl:text><xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/></xsl:template><xsl:template match="/" mode="generate-id-2">U</xsl:template><xsl:template match="*" mode="generate-id-2" priority="2"><xsl:text>U</xsl:text><xsl:number count="*" level="multiple"/></xsl:template><xsl:template match="node()" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number count="*" level="multiple"/><xsl:text>n</xsl:text><xsl:number count="node()"/></xsl:template><xsl:template match="@*" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number count="*" level="multiple"/><xsl:text>_</xsl:text><xsl:value-of select="string-length(local-name(.))"/><xsl:text>_</xsl:text><xsl:value-of select="translate(name(),':','.')"/></xsl:template><xsl:template match="text()" priority="-1"/><xsl:template match="/"><svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" schemaVersion="ISO19757-3" title="XDD/XDC-Check"><xsl:comment><xsl:value-of select="$archiveDirParameter"/>   <xsl:value-of select="$archiveNameParameter"/>  <xsl:value-of select="$fileNameParameter"/>  <xsl:value-of select="$fileDirParameter"/></xsl:comment><svrl:ns-prefix-in-attribute-values prefix="epl" uri="http://www.ethernet-powerlink.org"/><svrl:ns-prefix-in-attribute-values prefix="myFunction" uri="http://br-automation.com/customXSLTFunctions"/><svrl:ns-prefix-in-attribute-values prefix="xalan" uri="http://xml.apache.org/xalan/java/org.apache.xalan.lib.NodeInfo"/><svrl:ns-prefix-in-attribute-values prefix="saxon" uri="http://saxon.sf.net/"/><svrl:ns-prefix-in-attribute-values prefix="xs" uri="http://www.w3.org/2001/XMLSchema"/><svrl:ns-prefix-in-attribute-values prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.info</xsl:attribute><xsl:attribute name="name">FileInfo</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M13" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.constants</xsl:attribute><xsl:attribute name="name">pattern.constants</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M14" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.existence.common.mandatoryObjects</xsl:attribute><xsl:attribute name="name">Checking existence of mandatory common objects...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M15" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.existence.CN.mandatoryObjects</xsl:attribute><xsl:attribute name="name">Checking existence of mandatory CN-Objects...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M16" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.existence.common.conditionalObjects</xsl:attribute><xsl:attribute name="name">Checking common object dependencies...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M17" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.existence.CN.conditionalObjects</xsl:attribute><xsl:attribute name="name">Checking CN-Object dependencies...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M18" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern_check_objects_common</xsl:attribute><xsl:attribute name="name">Checking constraints of common objects...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M19" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.check.CN.objects</xsl:attribute><xsl:attribute name="name">Checking constraints of CN-Objects...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M20" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern_check_objects_shared</xsl:attribute><xsl:attribute name="name">Object checks common to multiple objects...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M21" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.misc</xsl:attribute><xsl:attribute name="name">Various XDD-Checks...</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M22" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.epsg-ds302c-v100.objects</xsl:attribute><xsl:attribute name="name">Checking Poll-Response Chaining (EPSG DS302-C v1.0.0)</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M23" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.epsg-ds302c-v100.objects</xsl:attribute><xsl:attribute name="name">Checking DNA (EPSG DS302-E v1.1.0)</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M24" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.epsg-ds302f-v100.objects</xsl:attribute><xsl:attribute name="name">Checking Modular Node Support (EPSG DS302-F v1.0.0)</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M25" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">pattern.arrays</xsl:attribute><xsl:attribute name="name">pattern.arrays</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M26" select="/"/></svrl:schematron-output></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">XDD/XDC-Check</svrl:text><xsl:param name="schematron.schemaVersion" select="'v1.3.3'"/><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">FileInfo</svrl:text><xsl:template match="epl:ISO15745Profile[1]/epl:ProfileBody" mode="M13" priority="1000"><xsl:if test="true()"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true()"><xsl:attribute name="role">info</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="info.fileName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Filename: <xsl:text/><xsl:value-of select="@fileName"/><xsl:text/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="info.fileName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Dateiname: <xsl:text/><xsl:value-of select="@fileName"/><xsl:text/></svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="true()"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true()"><xsl:attribute name="role">info</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="info.fileCreationDate.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Created on: <xsl:text/><xsl:value-of select="@fileCreationDate"/><xsl:text/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="info.fileCreationDate.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Erzeugt am: <xsl:text/><xsl:value-of select="@fileCreationDate"/><xsl:text/></svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="true()"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true()"><xsl:attribute name="role">info</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="info.fileModificationDate.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Modified on: <xsl:text/><xsl:value-of select="@fileModificationDate"/><xsl:text/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="info.fileModificationDate.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Bearbeitet am: <xsl:text/><xsl:value-of select="@fileModificationDate"/><xsl:text/></svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="true()"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true()"><xsl:attribute name="role">info</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="info.fileVersion.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Fileversion: <xsl:text/><xsl:value-of select="@fileVersion"/><xsl:text/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="info.fileVersion.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Dateiversion: <xsl:text/><xsl:value-of select="@fileVersion"/><xsl:text/></svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="true()"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true()"><xsl:attribute name="role">info</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="info.schematronSchemaVersion.en"><xsl:attribute name="xml:lang">en</xsl:attribute>XDD-Check version: <xsl:text/><xsl:value-of select="$schematron.schemaVersion"/><xsl:text/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="info.schematronSchemaVersion.de"><xsl:attribute name="xml:lang">de</xsl:attribute>XDD-Check version: <xsl:text/><xsl:value-of select="$schematron.schemaVersion"/><xsl:text/></svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="@xsi:type='ProfileBody_Device_Powerlink_Modular_Child'"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xsi:type='ProfileBody_Device_Powerlink_Modular_Child'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="warning.cnType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Modular child devices cannot be semantically validated by the XDD checker tool.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="warning.cnType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Modulare Kindgeräte koennen vom XDD Checker nicht semantisch ueberprueft werden.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M13" select="@*|*"/></xsl:template><xsl:template match="text()" mode="M13" priority="-1"/><xsl:template match="@*|node()" mode="M13" priority="-2"><xsl:apply-templates mode="M13" select="@*|*"/></xsl:template><xsl:variable name="UNSIGNED64_MIN" select="0"/><xsl:variable name="UNSIGNED64_MAX" select="18446744073709551616"/><xsl:variable name="UNSIGNED56_MIN" select="0"/><xsl:variable name="UNSIGNED56_MAX" select="72057594037927935"/><xsl:variable name="UNSIGNED48_MIN" select="0"/><xsl:variable name="UNSIGNED48_MAX" select="281474976710655"/><xsl:variable name="UNSIGNED40_MIN" select="0"/><xsl:variable name="UNSIGNED40_MAX" select="1099511627775"/><xsl:variable name="UNSIGNED32_MIN" select="0"/><xsl:variable name="UNSIGNED32_MAX" select="4294967295"/><xsl:variable name="UNSIGNED24_MIN" select="0"/><xsl:variable name="UNSIGNED24_MAX" select="16777215"/><xsl:variable name="UNSIGNED16_MIN" select="0"/><xsl:variable name="UNSIGNED16_MAX" select="65535"/><xsl:variable name="UNSIGNED8_MIN" select="0"/><xsl:variable name="UNSIGNED8_MAX" select="255"/><xsl:variable name="INTEGER64_MIN" select="-9223372036854775808"/><xsl:variable name="INTEGER64_MAX" select="9223372036854775807"/><xsl:variable name="INTEGER56_MIN" select="-36028797018963968"/><xsl:variable name="INTEGER56_MAX" select="36028797018963967"/><xsl:variable name="INTEGER48_MIN" select="-140737488355328"/><xsl:variable name="INTEGER48_MAX" select="140737488355327"/><xsl:variable name="INTEGER40_MIN" select="-549755813888"/><xsl:variable name="INTEGER40_MAX" select="549755813887"/><xsl:variable name="INTEGER32_MIN" select="-2147483648"/><xsl:variable name="INTEGER32_MAX" select="2147483647"/><xsl:variable name="INTEGER24_MIN" select="-8388608"/><xsl:variable name="INTEGER24_MAX" select="8388607"/><xsl:variable name="INTEGER16_MIN" select="-32768"/><xsl:variable name="INTEGER16_MAX" select="32767"/><xsl:variable name="INTEGER8_MIN" select="-128"/><xsl:variable name="INTEGER8_MAX" select="127"/><xsl:variable name="OBJECTTYPE_DEFTYPE" select="5"/><xsl:variable name="OBJECTTYPE_DEFSTRUCT" select="6"/><xsl:variable name="OBJECTTYPE_VAR" select="7"/><xsl:variable name="OBJECTTYPE_ARRAY" select="8"/><xsl:variable name="OBJECTTYPE_RECORD" select="9"/><xsl:variable name="DATATYPE_BOOLEAN" select="'0001'"/><xsl:variable name="DATATYPE_INTEGER8" select="'0002'"/><xsl:variable name="DATATYPE_INTEGER16" select="'0003'"/><xsl:variable name="DATATYPE_INTEGER32" select="'0004'"/><xsl:variable name="DATATYPE_UNSIGNED8" select="'0005'"/><xsl:variable name="DATATYPE_UNSIGNED16" select="'0006'"/><xsl:variable name="DATATYPE_UNSIGNED32" select="'0007'"/><xsl:variable name="DATATYPE_REAL32" select="'0008'"/><xsl:variable name="DATATYPE_VISIBLESTRING" select="'0009'"/><xsl:variable name="DATATYPE_INTEGER24" select="'0010'"/><xsl:variable name="DATATYPE_REAL64" select="'0011'"/><xsl:variable name="DATATYPE_INTEGER40" select="'0012'"/><xsl:variable name="DATATYPE_INTEGER48" select="'0013'"/><xsl:variable name="DATATYPE_INTEGER56" select="'0014'"/><xsl:variable name="DATATYPE_INTEGER64" select="'0015'"/><xsl:variable name="DATATYPE_OCTETSTRING" select="'000A'"/><xsl:variable name="DATATYPE_UNICODESTRING" select="'000B'"/><xsl:variable name="DATATYPE_TIMEOFDAY" select="'000C'"/><xsl:variable name="DATATYPE_TIMEDIFF" select="'000D'"/><xsl:variable name="DATATYPE_DOMAIN" select="'000F'"/><xsl:variable name="DATATYPE_UNSIGNED24" select="'0016'"/><xsl:variable name="DATATYPE_UNSIGNED40" select="'0018'"/><xsl:variable name="DATATYPE_UNSIGNED48" select="'0019'"/><xsl:variable name="DATATYPE_UNSIGNED56" select="'001A'"/><xsl:variable name="DATATYPE_UNSIGNED64" select="'001B'"/><xsl:variable name="DATATYPE_MACADDRESS" select="'0401'"/><xsl:variable name="DATATYPE_IPADDRESS" select="'0402'"/><xsl:variable name="DATATYPE_NETTIME" select="'0403'"/><xsl:variable name="DATATYPE_IDENTITY" select="'0023'"/><xsl:variable name="DATATYPE_NMT_EPLNODEID_TYPE" select="'0439'"/><xsl:variable name="DATATYPE_DLL_ERRORCNTREC_TYPE" select="'0424'"/><xsl:variable name="DATATYPE_NWL_IPGROUP_TYPE" select="'0425'"/><xsl:variable name="DATATYPE_NWL_IPADDRTABLE_TYPE" select="'0426'"/><xsl:variable name="DATATYPE_SDO_PARAMETERRECORD_TYPE" select="'0422'"/><xsl:variable name="DATATYPE_PDO_COMMPARAMRECORD_TYPE" select="'0420'"/><xsl:variable name="DATATYPE_PDL_LOCVERAPPLSW_TYPE" select="'0427'"/><xsl:variable name="DATATYPE_CFM_VERIFYCONFIGURATION_TYPE" select="'0435'"/><xsl:variable name="DATATYPE_INP_PROCESSIMAGE_TYPE" select="'0428'"/><xsl:variable name="DATATYPE_NMT_PARAMETERSTORAGE_TYPE" select="'0429'"/><xsl:variable name="DATATYPE_NMT_INTERFACEGROUP_Xh_TYPE" select="'042B'"/><xsl:variable name="DATATYPE_NMT_CYCLETIMING_TYPE" select="'042C'"/><xsl:variable name="DATATYPE_NMT_BOOTTIME_TYPE" select="'042E'"/><xsl:variable name="DATATYPE_NMT_MNCYCLETIMING_TYPE" select="'042F'"/><xsl:variable name="DATATYPE_DIA_NMTTELEGRCOUNT_TYPE" select="'0437'"/><xsl:variable name="DATATYPE_DIA_ERRSTATISTICS_TYPE" select="'0438'"/><xsl:variable name="DATATYPE_RT1_EPLROUTER_TYPE" select="'0430'"/><xsl:variable name="DATATYPE_RT1_SECURITYGROUP_TYPE" select="'0433'"/><xsl:variable name="DATATYPE_RT1_IPROUTINGTABLE_TYPE" select="'0431'"/><xsl:variable name="DATATYPE_RT1_NATTABLE_TYPE" select="'0432'"/><xsl:variable name="DATATYPE_RT1_ACLTABLE_TYPE" select="'0434'"/><xsl:variable name="DATATYPE_NMT_REQUESTCMD_TYPE" select="'043A'"/><xsl:variable name="DATATYPE_DLL_MNRINGREDUNDANCY_TYPE" select="'043B'"/><xsl:variable name="ACCESSTYPE_CONST" select="'const'"/><xsl:variable name="ACCESSTYPE_RO" select="'ro'"/><xsl:variable name="ACCESSTYPE_WO" select="'wo'"/><xsl:variable name="ACCESSTYPE_RW" select="'rw'"/><xsl:variable name="PDOMAPPING_NO" select="'no'"/><xsl:variable name="PDOMAPPING_DEFAULT" select="'default'"/><xsl:variable name="PDOMAPPING_OPTIONAL" select="'optional'"/><xsl:variable name="PDOMAPPING_RPDO" select="'RPDO'"/><xsl:variable name="PDOMAPPING_TPDO" select="'TPDO'"/><xsl:variable name="PDOMAPPING_true" select="'true'"/><xsl:variable name="PDOMAPPING_false" select="'false'"/><xsl:variable name="C_ADR_SELF_ADR_NODE_ID" select="251"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="featureFlagsDec" select="myFunction:hex2dec(//epl:ObjectList/epl:Object[@index='1F82']/@defaultValue)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="featureFlagsBin" select="myFunction:dec2bin($featureFlagsDec)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="featureFlagsBitCount" select="string-length($featureFlagsBin)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="NodeIdBySWSupport" select="substring($featureFlagsBin, $featureFlagsBitCount - 10, 1) = '1'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="DynamicMappingSupport" select="substring($featureFlagsBin, $featureFlagsBitCount - 6, 1) = '1'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="MultiplexingSupport" select="substring($featureFlagsBin, $featureFlagsBitCount - 9, 1) = '1'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="ExtendedNMTStateCommands" select="substring($featureFlagsBin, $featureFlagsBitCount - 5, 1) = '1'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="IsMN" select="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@DLLFeatureMN = 'true'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="IsCN" select="(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@DLLFeatureCN = 'true')   or not(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@DLLFeatureCN)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="NMTMaxHeartbeats"><xsl:choose><xsl:when test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NMTMaxHeartbeats"><xsl:value-of select="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NMTMaxHeartbeats"/></xsl:when><xsl:otherwise><xsl:value-of select="254"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="NMTCycleTimeMin" select="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NMTCycleTimeMin"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="NMTCycleTimeMax" select="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NMTCycleTimeMax"/><xsl:template match="text()" mode="M14" priority="-1"/><xsl:template match="@*|node()" mode="M14" priority="-2"><xsl:apply-templates mode="M14" select="@*|*"/></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking existence of mandatory common objects...</svrl:text><xsl:template match="epl:ObjectList" mode="M15" priority="1000"><xsl:choose><xsl:when test="epl:Object[@index='1000']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1000']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1000.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1000h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1000.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1000h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1001']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1001']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1001.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1001h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1001.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1001h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1006']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1006']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1006.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1006h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1006.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1006h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1018']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1018']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1018.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1018h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1018.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1018h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1020']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1020']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1020.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1020h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1020.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1020h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1030']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1030']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1030.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1030h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1030.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1030h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1300']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1300']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1300.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1300h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1300.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1300h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F82']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F82']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F82.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F82h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F82.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F82h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F83']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F83']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F83.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F83h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F83.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F83h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F8C']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F8C']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F8C.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F8Ch is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F8C.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F8Ch muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F93']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F93']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F93.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F93h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F93.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F93h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F98']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F98']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F98.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F98h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F98.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F98h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F9E']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F9E']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F9E.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F9Eh is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F9E.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F9Eh muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M15" select="@*|*"/></xsl:template><xsl:template match="text()" mode="M15" priority="-1"/><xsl:template match="@*|node()" mode="M15" priority="-2"><xsl:apply-templates mode="M15" select="@*|*"/></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking existence of mandatory CN-Objects...</svrl:text><xsl:template match="epl:ObjectList" mode="M16" priority="1000"><xsl:choose><xsl:when test="epl:Object[@index='1C0B']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1C0B']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C0B.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1C0Bh is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C0B.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1C0Bh muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1C0F']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1C0F']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C0F.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1C0Fh is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C0F.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1C0Fh muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1C14']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1C14']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C14.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1C14h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1C14.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1C14h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:Object[@index='1F99']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:Object[@index='1F99']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F99.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F99h is mandatory but was not found.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatoryObject1F99.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F99h muss vorhanden sein, wurde aber nicht gefunden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M16" select="@*|*"/></xsl:template><xsl:template match="text()" mode="M16" priority="-1"/><xsl:template match="@*|node()" mode="M16" priority="-2"><xsl:apply-templates mode="M16" select="@*|*"/></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking common object dependencies...</svrl:text><xsl:template match="epl:Object[starts-with(@index, '14')]" mode="M17" priority="1007"><xsl:variable name="endsWith" select="substring-after(@index, '14')"/><xsl:variable name="missingObjectIndex" select="concat('16', $endsWith)"/><xsl:choose><xsl:when test="boolean(../epl:Object[@index=$missingObjectIndex])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(../epl:Object[@index=$missingObjectIndex])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '16')]" mode="M17" priority="1006"><xsl:variable name="endsWith" select="substring-after(@index, '16')"/><xsl:variable name="missingObjectIndex" select="concat('14', $endsWith)"/><xsl:choose><xsl:when test="boolean(../epl:Object[@index=$missingObjectIndex])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(../epl:Object[@index=$missingObjectIndex])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '18')]" mode="M17" priority="1005"><xsl:variable name="endsWith" select="substring-after(@index, '18')"/><xsl:variable name="missingObjectIndex" select="concat('1A', $endsWith)"/><xsl:choose><xsl:when test="boolean(../epl:Object[@index=$missingObjectIndex])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(../epl:Object[@index=$missingObjectIndex])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '1A')]" mode="M17" priority="1004"><xsl:variable name="endsWith" select="substring-after(@index, '1A')"/><xsl:variable name="missingObjectIndex" select="concat('18', $endsWith)"/><xsl:choose><xsl:when test="boolean(../epl:Object[@index=$missingObjectIndex])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(../epl:Object[@index=$missingObjectIndex])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1E40'] | epl:Object[@index='1E4A'] | epl:Object[@index='1F9A']" mode="M17" priority="1003"><xsl:choose><xsl:when test="(not(boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NWLIPSupport))) or (/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NWLIPSupport='true')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(not(boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NWLIPSupport))) or (/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NWLIPSupport='true')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupportMissing.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h detected: Requires attribute //NetworkManagement/GeneralFeatures/@NWLIPSupport to be either non-existent (defaults to 'true') or be set to 'true'.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupportMissing.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h gefunden: Erfordert Wert 'true' fuer Attribut //NetworkManagement/GeneralFeatures/@NWLIPSupport (explizit oder implizit durch Fehlen des Attributs).</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NWLIPSupport[. = 'true']" mode="M17" priority="1002"><xsl:choose><xsl:when test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1E40'])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1E40'])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1E40.en"><xsl:attribute name="xml:lang">en</xsl:attribute>IP-Support detected: Requires object 1E40h to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1E40.de"><xsl:attribute name="xml:lang">de</xsl:attribute>IP-Support aktiviert: Erfordert Implementierung von Objekt 1E40h.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1E4A'])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1E4A'])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1E4A.en"><xsl:attribute name="xml:lang">en</xsl:attribute>IP-Support detected: Requires object 1E4Ah to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1E4A.de"><xsl:attribute name="xml:lang">de</xsl:attribute>IP-Support aktiviert: Erfordert Implementierung von Objekt 1E4Ah.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1F9A'])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index='1F9A'])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1F9A.en"><xsl:attribute name="xml:lang">en</xsl:attribute>IP-Support detected: Requires object 1F9Ah to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectIPSupport1F9A.de"><xsl:attribute name="xml:lang">de</xsl:attribute>IP-Support aktiviert: Erfordert Implementierung von Objekt 1F9Ah.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '1D')]   | epl:Object[@index = '1E80']   | epl:Object[@index = '1E81']   | epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 144 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 207]   | epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 208 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 223]   | epl:Object[starts-with(@index, '1EE') and myFunction:hex2dec(concat('0x', substring(@index, 4))) &gt;= 0 and myFunction:hex2dec(concat('0x', substring(@index, 4))) &lt;= 15]   | epl:Object[starts-with(@index, '1B')]" mode="M17" priority="1001"><xsl:choose><xsl:when test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@RT1RT1Support = 'true'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@RT1RT1Support = 'true'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1SupportMissing.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h detected: Requires attribute //NetworkManagement/GeneralFeatures/@RT1RT1Support set to 'true'.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1SupportMissing.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h gefunden: Erfordert Wert 'true' fuer Attribut //NetworkManagement/GeneralFeatures/@RT1RT1Support.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@RT1RT1Support[. = 'true']" mode="M17" priority="1000"><xsl:choose><xsl:when test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1D')]) = 256"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1D')]) = 256"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1DXX.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires objects 1D00h-1DFFh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1DXX.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekten 1D00h-1DFFh.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1E80']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1E80']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E80.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires object 1E80h to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E80.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekt 1E80h.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1E81']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1E81']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E81.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires object 1E81h to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E81.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekt 1E81h.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 144 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 207]) = 64"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 144 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 207]) = 64"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E90_1ECF.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires objects 1E90h-1ECFh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1E90_1ECF.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekten 1E90h-1ECF.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 208 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 223]) = 16"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1E') and myFunction:hex2dec(concat('0x', substring(@index, 3))) &gt;= 208 and myFunction:hex2dec(concat('0x', substring(@index, 3))) &lt;= 223]) = 16"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1ED0_1EDF.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires objects 1ED0h-1EDFh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1ED0_1EDF.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekten 1ED0h-1EDF.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1EE') and myFunction:hex2dec(concat('0x', substring(@index, 4))) &gt;= 0 and myFunction:hex2dec(concat('0x', substring(@index, 4))) &lt;= 15]) = 16"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1EE') and myFunction:hex2dec(concat('0x', substring(@index, 4))) &gt;= 0 and myFunction:hex2dec(concat('0x', substring(@index, 4))) &lt;= 15]) = 16"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1EE0_1EEF.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires objects 1EE0h-1EEFh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1EE0_1EEF.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekten 1EE0h-1EEF.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1B')]) = 256"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[starts-with(@index, '1B')]) = 256"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1BXX.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Routing type 1 support detected (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Requires objects 1B00h-1BFFh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectRT1Support1BXX.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Routing type 1 Support aktiviert (//NetworkManagement/GeneralFeatures/@RT1RT1Support): Erfordert Implementierung von Objekten 1B00h-1BFFh.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><xsl:template match="text()" mode="M17" priority="-1"/><xsl:template match="@*|node()" mode="M17" priority="-2"><xsl:apply-templates mode="M17" select="@*|*"/></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking CN-Object dependencies...</svrl:text><xsl:template match="epl:Object[@index='1021']" mode="M18" priority="1005"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingObjectIndex" select="'1022'"/><xsl:choose><xsl:when test="../epl:Object[@index='1022']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1022']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1F50']" mode="M18" priority="1004"><xsl:choose><xsl:when test="../epl:Object[@index='1F51']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1F51']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject1F51.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F51h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject1F51.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F51h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="../epl:Object[@index='1F52']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1F52']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject1F52.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object 1F52h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject1F52.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt 1F52h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1F51'] | epl:Object[@index='1F52']" mode="M18" priority="1003"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingObjectIndex" select="'1F50'"/><xsl:choose><xsl:when test="../epl:Object[@index='1F50']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1F50']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1016'] | epl:Object[@index='1F8D']" mode="M18" priority="1002"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingObjectIndex" select="'1F81'"/><xsl:choose><xsl:when test="../epl:Object[@index='1F81']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1F81']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1F9B']" mode="M18" priority="1001"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingObjectIndex" select="'1F81'"/><xsl:choose><xsl:when test="../epl:Object[@index='1F81']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="../epl:Object[@index='1F81']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObject.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h missing. Expected because object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h depends on it.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObject.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$missingObjectIndex"/><xsl:text/>h erwartet, da Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h davon abhaengig ist.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:CNFeatures" mode="M18" priority="1000"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" as="xs:boolean" name="DLLCNFeatureMultiplex" select="@DLLCNFeatureMultiplex = 'true'"/><xsl:choose><xsl:when test="($MultiplexingSupport and $DLLCNFeatureMultiplex and boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1F9B']))    or (not($MultiplexingSupport) and not($DLLCNFeatureMultiplex))    or ($MultiplexingSupport != $DLLCNFeatureMultiplex)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($MultiplexingSupport and $DLLCNFeatureMultiplex and boolean(/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:ApplicationLayers/epl:ObjectList/epl:Object[@index = '1F9B'])) or (not($MultiplexingSupport) and not($DLLCNFeatureMultiplex)) or ($MultiplexingSupport != $DLLCNFeatureMultiplex)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.conditionalObjectMultiplexing1F9B.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Multiplexing-Support detected (//NetworkManagement/MNFeatures/@DLLMNFeatureMultiplex for MNs, @DLLCNFeatureMultiplex and object 0x1F82/Bit 9 for CNs): Requires object 1F9Bh to be implemented.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.conditionalObjectMultiplexing1F9B.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Multiplexing-Support aktiviert (//NetworkManagement/MNFeatures/@DLLMNFeatureMultiplex fuer MNs, @DLLCNFeatureMultiplex und Objekt 0x1F82/Bit 9 fuer CNs): Erfordert Implementierung von Objekt 1F9Bh.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><xsl:template match="text()" mode="M18" priority="-1"/><xsl:template match="@*|node()" mode="M18" priority="-2"><xsl:apply-templates mode="M18" select="@*|*"/></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Checking constraints of common objects...</svrl:text><xsl:template match="epl:Object[@index='1000' or @index='1F82']" mode="M19" priority="1351"><xsl:choose><xsl:when test="@index='1000' and @name='NMT_DeviceType_U32' or @index='1F82' and @name='NMT_FeatureFlags_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@index='1000' and @name='NMT_DeviceType_U32' or @index='1F82' and @name='NMT_FeatureFlags_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1001']" mode="M19" priority="1350"><xsl:choose><xsl:when test="@name='ERR_ErrorRegister_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ERR_ErrorRegister_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_OPTIONAL or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_OPTIONAL or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "defaultValue" value ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: default Wert ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1003']" mode="M19" priority="1349"><xsl:choose><xsl:when test="@name='ERR_History_ADOM'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ERR_History_ADOM'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_ARRAY"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_ARRAY"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingSubObjectIndex" select="00"/><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1003']/epl:SubObject[@subIndex='00']" mode="M19" priority="1348"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_OPTIONAL or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_OPTIONAL or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=0 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=0 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=254 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=254 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1003']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF']" mode="M19" priority="1347"><xsl:choose><xsl:when test="@name='ErrorEntry_DOM'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ErrorEntry_DOM'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1006']" mode="M19" priority="1346"><xsl:choose><xsl:when test="@name='NMT_CycleLen_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NMT_CycleLen_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1006']/@defaultValue" mode="M19" priority="1345"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="NMTCycleTimeGranularity"><xsl:choose><xsl:when test="/epl:ISO15745ProfileContainer/epl:ISO15745Profile[2]/epl:ProfileBody/epl:NetworkManagement/epl:GeneralFeatures/@NMTCycleTimeGranularity"><xsl:value-of select="myFunction:hex2dec(//epl:NetworkManagement/epl:GeneralFeatures/@NMTCycleTimeGranularity)"/></xsl:when><xsl:otherwise><xsl:value-of select="1"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="index" select="string(../@index)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="subIndex" select="''"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="expectedLowLimit" select="$NMTCycleTimeMin"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="expectedHighLimit" select="$NMTCycleTimeMax"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="defaultValue" select="myFunction:hex2dec(.)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="highLimit" select="myFunction:hex2dec(../@highLimit)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="lowLimit" select="myFunction:hex2dec(../@lowLimit)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="expectedHighLimitSource" select="'//NetworkManagement/GeneralFeatures/@NMTCycleTimeMax'"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="expectedLowLimitSource" select="'//NetworkManagement/GeneralFeatures/@NMTCycleTimeMin'"/><xsl:choose><xsl:when test="not(../@highLimit) or ($highLimit = $expectedHighLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(../@highLimit) or ($highLimit = $expectedHighLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dynamicHighLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', subObject ', $subIndex, 'h')"/></xsl:if>: Value of attribute 'highLimit' invalid. Actual: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$highLimit"/>. Expected: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimitSource"/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dynamicHighLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', Subobjekt ', $subIndex, 'h')"/></xsl:if>: Wert von Attribut 'highLimit' ungueltig. Vorhanden: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$highLimit"/>. Erwartet: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimitSource"/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(../@lowLimit) or ($lowLimit = $expectedLowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(../@lowLimit) or ($lowLimit = $expectedLowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dynamicLowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', subObject ', $subIndex, 'h')"/></xsl:if>: Value of attribute 'lowLimit' invalid. Actual: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$lowLimit"/>. Expected: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimitSource"/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dynamicLowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', Subobjekt ', $subIndex, 'h')"/></xsl:if>: Wert von Attribut 'lowLimit' ungueltig. Vorhanden: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$lowLimit"/>. Erwartet: <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimitSource"/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="($defaultValue &gt;= $expectedLowLimit) and ($defaultValue &lt;= $expectedHighLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($defaultValue &gt;= $expectedLowLimit) and ($defaultValue &lt;= $expectedHighLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotInDynamicRange.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', subObject ', $subIndex, 'h')"/></xsl:if>: Value of attribute 'defaultValue' (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$defaultValue"/>) shall be &gt;= <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimitSource"/>) and &lt;= <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimitSource"/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotInDynamicRange.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="$index"/><xsl:text/>h<xsl:if xmlns="http://purl.oclc.org/dsdl/schematron" test="$subIndex != ''"><xsl:value-of select="concat(', SubObjekt ', $subIndex, 'h')"/></xsl:if>: Wert von Attribut 'defaultValue' (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$defaultValue"/>) muss &gt;= <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedLowLimitSource"/>) und &lt;= <xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimit"/> (<xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="$expectedHighLimitSource"/>) sein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="($defaultValue mod $NMTCycleTimeGranularity) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($defaultValue mod $NMTCycleTimeGranularity) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectValue.cycletimeGranularity.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h: "defaultValue" (<xsl:text/><xsl:value-of select="$defaultValue"/><xsl:text/>) shall be a multiple of //NetworkManagement/GeneralFeatures/@NMTCycleTimeGranularity (<xsl:text/><xsl:value-of select="$NMTCycleTimeGranularity"/><xsl:text/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectValue.cycletimeGranularity.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h: Default-Wert (<xsl:text/><xsl:value-of select="$defaultValue"/><xsl:text/>) muss ein Vielfaches von //NetworkManagement/GeneralFeatures/@NMTCycleTimeGranularity sein (<xsl:text/><xsl:value-of select="$NMTCycleTimeGranularity"/><xsl:text/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1008' or @index='1009' or @index='100A']" mode="M19" priority="1344"><xsl:choose><xsl:when test="@index='1008' and @name='NMT_ManufactDevName_VS' or @index='1009' and @name='NMT_ManufactHwVers_VS' or @index='100A' and @name='NMT_ManufactSwVers_VS'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@index='1008' and @name='NMT_ManufactDevName_VS' or @index='1009' and @name='NMT_ManufactHwVers_VS' or @index='100A' and @name='NMT_ManufactSwVers_VS'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1010' or @index='1011' or @index='1018']" mode="M19" priority="1343"><xsl:choose><xsl:when test="@index='1010' and @name='NMT_StoreParam_REC' or @index='1011' and @name='NMT_RestoreDefParam_REC' or @index='1018' and @name='NMT_IdentityObject_REC'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@index='1010' and @name='NMT_StoreParam_REC' or @index='1011' and @name='NMT_RestoreDefParam_REC' or @index='1018' and @name='NMT_IdentityObject_REC'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1010' or @index='1011']/epl:SubObject[@subIndex='00']" mode="M19" priority="1342"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=127 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=127 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1010']/epl:SubObject[@subIndex='01' or @subIndex='02' or @subIndex='03']" mode="M19" priority="1341"><xsl:choose><xsl:when test="@subIndex='01' and @name='AllParam_U32' or @subIndex='02' and @name='CommunicationParam_U32' or @subIndex='03' and @name='ApplicationParam_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@subIndex='01' and @name='AllParam_U32' or @subIndex='02' and @name='CommunicationParam_U32' or @subIndex='03' and @name='ApplicationParam_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1010']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF'or @subIndex!='01' or @subIndex!='02' or @subIndex!='03']" mode="M19" priority="1340"><xsl:choose><xsl:when test="@name = concat('ManufacturerParam_', @subIndex, 'h_U32')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('ManufacturerParam_', @subIndex, 'h_U32')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1011']/epl:SubObject[@subIndex='01' or @subIndex='02' or @subIndex='03']" mode="M19" priority="1339"><xsl:choose><xsl:when test="@subIndex='01' and @name='AllParam_U32' or @subIndex='02' and @name='CommunicationParam_U32' or @subIndex='03' and @name='ApplicationParam_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@subIndex='01' and @name='AllParam_U32' or @subIndex='02' and @name='CommunicationParam_U32' or @subIndex='03' and @name='ApplicationParam_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1011']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF'or @subIndex!='01' or @subIndex!='02' or @subIndex!='03']" mode="M19" priority="1338"><xsl:choose><xsl:when test="@name = concat('ManufacturerParam_', @subIndex, 'h_U32')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('ManufacturerParam_', @subIndex, 'h_U32')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1016']" mode="M19" priority="1337"><xsl:choose><xsl:when test="@name='NMT_ConsumerHeartbeatTime_AU32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NMT_ConsumerHeartbeatTime_AU32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_ARRAY"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_ARRAY"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1016']/epl:SubObject[@subIndex='00']" mode="M19" priority="1336"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1016']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF']" mode="M19" priority="1335"><xsl:choose><xsl:when test="@name='HeartbeatDescription'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='HeartbeatDescription'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1018']/epl:SubObject[@subIndex='00']" mode="M19" priority="1334"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=4 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=4 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1018']/epl:SubObject[@subIndex='01' or @subIndex='02' or @subIndex='03' or @subIndex='04']" mode="M19" priority="1333"><xsl:choose><xsl:when test="@subIndex='01' and @name='VendorId_U32' or @subIndex='02' and @name='ProductCode_U32' or @subIndex='03' and @name='RevisionNo_U32' or @subIndex='04' and @name='SerialNo_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@subIndex='01' and @name='VendorId_U32' or @subIndex='02' and @name='ProductCode_U32' or @subIndex='03' and @name='RevisionNo_U32' or @subIndex='04' and @name='SerialNo_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1020']" mode="M19" priority="1332"><xsl:choose><xsl:when test="@name='CFM_VerifyConfiguration_REC'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='CFM_VerifyConfiguration_REC'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='02']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='02']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 02h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 02h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1020']/epl:SubObject[@subIndex='00']" mode="M19" priority="1331"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=2 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=2 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=4 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=4 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1020']/epl:SubObject[@subIndex='01' or @subIndex='02' or @subIndex='03']" mode="M19" priority="1330"><xsl:choose><xsl:when test="@subIndex='01' and @name='ConfDate_U32' or @subIndex='02' and @name='ConfTime_U32' or @subIndex='03' and @name='ConfId_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@subIndex='01' and @name='ConfDate_U32' or @subIndex='02' and @name='ConfTime_U32' or @subIndex='03' and @name='ConfId_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1020']/epl:SubObject[@subIndex='04']" mode="M19" priority="1329"><xsl:choose><xsl:when test="@name='VerifyConfInvalid_BOOL'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='VerifyConfInvalid_BOOL'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_BOOLEAN or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_BOOLEAN or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@defaultValue='true' or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@defaultValue='true' or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1021']" mode="M19" priority="1328"><xsl:choose><xsl:when test="@name='CFM_StoreDevDescrFile_DOM'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='CFM_StoreDevDescrFile_DOM'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW or @accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW or @accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_DOMAIN or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1022']" mode="M19" priority="1327"><xsl:choose><xsl:when test="@name='CFM_StoreDevDescrFormat_U16'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='CFM_StoreDevDescrFormat_U16'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW or @accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW or @accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1027']" mode="M19" priority="1326"><xsl:choose><xsl:when test="@name='NMT_ChildIdentList_AU16'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NMT_ChildIdentList_AU16'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_ARRAY"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_ARRAY"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1027' or @index='1F55']/epl:SubObject[@subIndex='00']" mode="M19" priority="1325"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1027']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF']" mode="M19" priority="1324"><xsl:choose><xsl:when test="@name='ChildIdentList'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ChildIdentList'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]" mode="M19" priority="1323"><xsl:choose><xsl:when test="@name = concat('NMT_InterfaceGroup_', substring(@index, 4), 'h_REC')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('NMT_InterfaceGroup_', substring(@index, 4), 'h_REC')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='02']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='02']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 02h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 02h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='03']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='03']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 03h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 03h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='04']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='04']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 04h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 04h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='05']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='05']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject05.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 05h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject05.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 05h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='06']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='06']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject06.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 06h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject06.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 06h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='07']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='07']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject07.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 07h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject07.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 07h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='08']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='08']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject08.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 08h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject08.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 08h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='09']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='09']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject09.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 09h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject09.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 09h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='00']" mode="M19" priority="1322"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=9 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=9 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=10 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=10 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='01']" mode="M19" priority="1321"><xsl:choose><xsl:when test="@name='InterfaceIndex_U16'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceIndex_U16'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=1 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "lowLimit" ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: LowLimit ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=10 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=10 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="defaultValue" select="myFunction:hex2dec(string(@defaultValue))"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="lastIndexDigit" select="substring(string(../@index), 4)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="comparisonValue" select="myFunction:hex2dec(../../epl:Object[@index=concat('1E4', $lastIndexDigit)]/epl:SubObject[@subIndex='01']/@defaultValue)"/><xsl:choose><xsl:when test="not(@defaultValue) or not(../../epl:Object[@index=concat('1E4', $lastIndexDigit)]/epl:SubObject[@subIndex='01']/@defaultValue) or ($comparisonValue = $defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@defaultValue) or not(../../epl:Object[@index=concat('1E4', $lastIndexDigit)]/epl:SubObject[@subIndex='01']/@defaultValue) or ($comparisonValue = $defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.103X_01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject 01h: "defaultValue" (<xsl:text/><xsl:value-of select="$defaultValue"/><xsl:text/>) has to be equal to 1E4<xsl:text/><xsl:value-of select="$lastIndexDigit"/><xsl:text/>h.01h (<xsl:text/><xsl:value-of select="$comparisonValue"/><xsl:text/>).</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.103X_01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt 01h: Wert (<xsl:text/><xsl:value-of select="$defaultValue"/><xsl:text/>) muss 1E4<xsl:text/><xsl:value-of select="$lastIndexDigit"/><xsl:text/>h.01h (<xsl:text/><xsl:value-of select="$comparisonValue"/><xsl:text/>) entsprechen.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='02']" mode="M19" priority="1320"><xsl:choose><xsl:when test="@name='InterfaceDescription_VSTR'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceDescription_VSTR'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='03']" mode="M19" priority="1319"><xsl:choose><xsl:when test="@name='InterfaceType_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceType_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=6 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=6 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='04']" mode="M19" priority="1318"><xsl:choose><xsl:when test="@name='InterfaceMtu_U16'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceMtu_U16'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED16 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='05']" mode="M19" priority="1317"><xsl:choose><xsl:when test="@name='InterfacePhysAddress_OSTR'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfacePhysAddress_OSTR'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_OCTETSTRING or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_OCTETSTRING or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='06']" mode="M19" priority="1316"><xsl:choose><xsl:when test="@name='InterfaceName_VSTR'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceName_VSTR'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_VISIBLESTRING or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='07']" mode="M19" priority="1315"><xsl:choose><xsl:when test="@name='InterfaceOperStatus_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceOperStatus_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=1 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=1 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='08']" mode="M19" priority="1314"><xsl:choose><xsl:when test="@name='InterfaceAdminState_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='InterfaceAdminState_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=1 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=1 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=1 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=1 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='09']" mode="M19" priority="1313"><xsl:choose><xsl:when test="@name='Valid_BOOL'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='Valid_BOOL'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_BOOLEAN or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_BOOLEAN or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index,'103')]/epl:SubObject[@subIndex='0A']" mode="M19" priority="1312"><xsl:choose><xsl:when test="@name='PortEnableMask_U64'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='PortEnableMask_U64'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED64 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED64 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1050']" mode="M19" priority="1311"><xsl:choose><xsl:when test="@name='NMT_RelativeLatencyDiff_AU32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NMT_RelativeLatencyDiff_AU32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_ARRAY"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_ARRAY"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1050']/epl:SubObject[@subIndex != '00' and @subIndex != 'FF']" mode="M19" priority="1310"><xsl:choose><xsl:when test="@name='RelativeLatencyDiff'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='RelativeLatencyDiff'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']" mode="M19" priority="1309"><xsl:choose><xsl:when test="@name='DIA_NMTTelegrCount_REC'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='DIA_NMTTelegrCount_REC'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='00']" mode="M19" priority="1308"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=8 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=8 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='01']" mode="M19" priority="1307"><xsl:choose><xsl:when test="@name='IsochrCyc_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='IsochrCyc_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='02']" mode="M19" priority="1306"><xsl:choose><xsl:when test="@name='IsochrRx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='IsochrRx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='03']" mode="M19" priority="1305"><xsl:choose><xsl:when test="@name='IsochrTx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='IsochrTx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='04']" mode="M19" priority="1304"><xsl:choose><xsl:when test="@name='AsyncRx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='AsyncRx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='05']" mode="M19" priority="1303"><xsl:choose><xsl:when test="@name='AsyncTx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='AsyncTx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='06']" mode="M19" priority="1302"><xsl:choose><xsl:when test="@name='SdoRx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='SdoRx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='07']" mode="M19" priority="1301"><xsl:choose><xsl:when test="@name='SdoTx_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='SdoTx_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1101']/epl:SubObject[@subIndex='08']" mode="M19" priority="1300"><xsl:choose><xsl:when test="@name='Status_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='Status_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']" mode="M19" priority="1299"><xsl:choose><xsl:when test="@name='DIA_ERRStatistics_REC'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='DIA_ERRStatistics_REC'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="missingSubObjectIndex" select="00"/><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='00']" mode="M19" priority="1298"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=7 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=7 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='01']" mode="M19" priority="1297"><xsl:choose><xsl:when test="@name='HistoryEntryWrite_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='HistoryEntryWrite_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='02']" mode="M19" priority="1296"><xsl:choose><xsl:when test="@name='EmergencyQueueWrite_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='EmergencyQueueWrite_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='03']" mode="M19" priority="1295"><xsl:choose><xsl:when test="@name='EmergencyQueueOverflow_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='EmergencyQueueOverflow_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='04']" mode="M19" priority="1294"><xsl:choose><xsl:when test="@name='StatusEntryChanged_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='StatusEntryChanged_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='05']" mode="M19" priority="1293"><xsl:choose><xsl:when test="@name='StaticErrorBitFieldChanged_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='StaticErrorBitFieldChanged_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='06']" mode="M19" priority="1292"><xsl:choose><xsl:when test="@name='ExceptionResetEdgePos_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ExceptionResetEdgePos_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1102']/epl:SubObject[@subIndex='07']" mode="M19" priority="1291"><xsl:choose><xsl:when test="@name='ExceptionNewEdge_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ExceptionNewEdge_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RO"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RO"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=0 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]" mode="M19" priority="1290"><xsl:choose><xsl:when test="@name = concat('SDO_ServerContainerParam_', substring(@index, 3), 'h_REC')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('SDO_ServerContainerParam_', substring(@index, 3), 'h_REC')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='02']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='02']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 02h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 02h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='03']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='03']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 03h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 03h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='04']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='04']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 04h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 04h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='00']" mode="M19" priority="1289"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=4 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=4 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "defaultValue" ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: DefaultValue ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='01']" mode="M19" priority="1288"><xsl:choose><xsl:when test="@name='ClientNodeID_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ClientNodeID_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='02']" mode="M19" priority="1287"><xsl:choose><xsl:when test="@name='ServerNodeID_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ServerNodeID_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='03']" mode="M19" priority="1286"><xsl:choose><xsl:when test="@name='ContainerLen_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ContainerLen_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[0-7]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='04']" mode="M19" priority="1285"><xsl:choose><xsl:when test="@name='HistorySize_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='HistorySize_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=63 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=63 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]" mode="M19" priority="1284"><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="calculatedIndex" select="myFunction:dec2hex(myFunction:hex2dec(concat('0x', substring(@index, 3))) - 128)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" name="comparisonIndex"><xsl:choose><xsl:when test="string-length($calculatedIndex) = 2"><xsl:value-of select="$calculatedIndex"/></xsl:when><xsl:otherwise><xsl:value-of select="concat('0', $calculatedIndex)"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:choose><xsl:when test="@name = concat('SDO_ClientContainerParam_', $comparisonIndex, 'h_REC')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('SDO_ClientContainerParam_', $comparisonIndex, 'h_REC')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='02']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='02']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 02h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 02h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='03']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='03']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 03h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject03.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 03h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='04']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='04']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 04h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject04.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 04h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='05']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='05']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject05.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 05h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject05.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 05h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='01']" mode="M19" priority="1283"><xsl:choose><xsl:when test="@name='ClientNodeID_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ClientNodeID_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='02']" mode="M19" priority="1282"><xsl:choose><xsl:when test="@name='ServerNodeID_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ServerNodeID_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='03']" mode="M19" priority="1281"><xsl:choose><xsl:when test="@name='ContainerLen_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='ContainerLen_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='04']" mode="M19" priority="1280"><xsl:choose><xsl:when test="@name='HistorySize_U8'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='HistorySize_U8'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED8 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@highLimit))=63 or not(@highLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@highLimit))=63 or not(@highLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "highLimit" ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') does not match the highLimit in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.highLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: HighLimit ('<xsl:text/><xsl:value-of select="@highLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[matches(@index,'^(12{1}[8-9A-F]{1}[0-9A-F])$')]/epl:SubObject[@subIndex='05']" mode="M19" priority="1279"><xsl:choose><xsl:when test="@name='Reserved'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='Reserved'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1300']" mode="M19" priority="1278"><xsl:choose><xsl:when test="@name='SDO_SequLayerTimeout_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='SDO_SequLayerTimeout_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=100 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=100 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "lowLimit" value ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: 'lowLimit' Wert ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=15000 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=15000 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "defaultValue" value ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: default Wert ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1301']" mode="M19" priority="1277"><xsl:choose><xsl:when test="@name='SDO_CmdLayerTimeout_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='SDO_CmdLayerTimeout_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=100 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=100 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "lowLimit" value ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: 'lowLimit' Wert ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=30000 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=30000 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "defaultValue" value ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: default Wert ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[@index='1302']" mode="M19" priority="1276"><xsl:choose><xsl:when test="@name='SDO_SequLayerNoAck_U32'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='SDO_SequLayerNoAck_U32'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_RW"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_RW"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@PDOmapping=$PDOMAPPING_NO or not(@PDOmapping)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "PDOMapping" value ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') does not match the PDO-mapping value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.pdoMapping.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: PDO-Mapping Wert ('<xsl:text/><xsl:value-of select="@PDOmapping"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@dataType=$DATATYPE_UNSIGNED32 or not(@dataType)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.dataType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "dataType" ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') does not match the dataType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.dataType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Datentyp ('<xsl:text/><xsl:value-of select="@dataType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@lowLimit))=2 or not(@lowLimit)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@lowLimit))=2 or not(@lowLimit)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "lowLimit" value ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') does not match the lowLimit value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.lowLimit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: 'lowLimit' Wert ('<xsl:text/><xsl:value-of select="@lowLimit"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="myFunction:hex2dec(string(@defaultValue))=2 or not(@defaultValue)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:hex2dec(string(@defaultValue))=2 or not(@defaultValue)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "defaultValue" value ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') does not match the defaultValue value in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.object.defaultValue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: default Wert ('<xsl:text/><xsl:value-of select="@defaultValue"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '14')]" mode="M19" priority="1275"><xsl:choose><xsl:when test="@name = concat('PDO_RxCommParam_', substring(@index, 3), 'h_REC')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name = concat('PDO_RxCommParam_', substring(@index, 3), 'h_REC')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectName.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectName.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_RECORD"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_RECORD"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@accessType))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@accessType))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "accessType" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.accessTypeNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "accessType" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@defaultValue))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@defaultValue))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "defaultValue" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.defaultValueNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "defaultValue" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(boolean(@PDOmapping))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(boolean(@PDOmapping))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Specification of "PDOmapping" not allowed.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.pdoMappingNotAllowed.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Spezifikation von "PDOmapping" nicht zulaessig.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='00']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='00']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 00h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject00.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 00h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='01']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='01']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 01h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject01.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 01h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="epl:SubObject[@subIndex='02']"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="epl:SubObject[@subIndex='02']"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Missing mandatory subObject 02h.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.mandatorySubObject02.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="@index"/><xsl:text/>h: Subobjekt 02h fehlt.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M19" select="@*|*"/></xsl:template><xsl:template match="epl:Object[starts-with(@index, '14')]/epl:SubObject[@subIndex='00']" mode="M19" priority="1274"><xsl:choose><xsl:when test="@name='NumberOfEntries'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@name='NumberOfEntries'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') does not match the object-name in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Name ('<xsl:text/><xsl:value-of select="@name"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@objectType=$OBJECTTYPE_VAR"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@objectType=$OBJECTTYPE_VAR"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "objectType" ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') does not match the objectType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.objectType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Typ ('<xsl:text/><xsl:value-of select="@objectType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('xalan:lineNumber', 0)) and not(function-available('saxon:line-number', 0))"/></svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.columnNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:column-number()" use-when="function-available('saxon:column-number', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="'NA'" use-when="not(function-available('saxon:column-number', 0))"/></svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@accessType=$ACCESSTYPE_CONST"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@accessType=$ACCESSTYPE_CONST"><xsl:attribute name="role">error</xsl:attribute><svrl:text/><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Object <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, subObject <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: "accessType" ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') does not match the accessType in the POWERLINK-Specification.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.subObject.accessType.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Objekt <xsl:text/><xsl:value-of select="../@index"/><xsl:text/>h, Subobjekt <xsl:text/><xsl:value-of select="@subIndex"/><xsl:text/>h: Zugriffstyp ('<xsl:text/><xsl:value-of select="@accessType"/><xsl:text/>') stimmt nicht mit jenem in der POWERLINK-Spezifikation ueberein.</svrl:diagnostic-reference><svrl:diagnostic-reference diagnostic="diag.lineNumber"><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="xalan:lineNumber()" use-when="function-available('xalan:lineNumber', 0)"/><xsl:value-of xmlns="http://purl.oclc.org/dsdl/schematron" select="saxon:line-number()" use-when="function-available('saxon:line-number', 0)"/><xs