<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns="http://www.w3.org/1999/xhtml" version="2.0">
	<xsl:output encoding="ISO-8859-1" method="xhtml" indent="yes" media-type="text/html" />
	<xsl:param name="lang" as="xs:string" />
	<xsl:param name="showReport" select="false()" />
	<xsl:param name="showWarning" select="false()" />
	<xsl:param name="username" as="xs:string" />
	<xsl:param name="os" as="xs:string" />
	<xsl:param name="md5" as="xs:string" />
	<xsl:param name="fileName" as="xs:string" />
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<title>openSAFETY Device Description Validation-Result</title>
				<style type="text/css">body { font-family:'Times New Roman';	font-size:12pt; } img.centered { display:block; margin-left:auto;	margin-right:auto; } *.centered { margin-left:auto;	margin-right:auto; } table.headerTable { border-style:none;	border-width:thin; height:50px; border-collapse:collapse; }	table.headerTable td { border-style:none; border-width:thin; }	table.indented { margin-left:20px; } h1, h2, h3 {	text-decoration:underline; page-break-after:avoid; } table.results	{ border-style:solid; border-width:thin; border-collapse:collapse;	} table.results td { border-style:solid; border-width:thin; }	table.results th { border-style:solid; border-width:medium;	padding-left:5px; padding-right:5px; }</style>
			</head>
			<body>
				<!-- Header -->
				<table class="headerTable centered">
					<tr>
						<td width="220px" style="background-color:#ff8800;">B&amp;R Industrial Automation GmbH<br />B&amp;R Straße<br />5142 Eggelsberg, Austria<br />Phone: +43 7748 6586 0<br />office@br-automation.com<br />www.br-automation.com<br />
						</td>
					</tr>
				</table>
				<h2 style="text-align:center; margin-bottom:50px;">openSAFETY Device Description Validation-Result</h2>
				<h3>Test-Execution</h3>
				<table class="indented">
					<tr>
						<td>Report file name:</td>
						<td>
							<xsl:value-of select="concat($fileName,'.html')" />
						</td>
					</tr>
					<tr>
						<td>Report created on:</td>
						<td>
							<xsl:value-of select="xs:dateTime(current-dateTime())" />
						</td>
					</tr>
				</table>
				<h3>Test-OSDD</h3>
				<table class="indented">
					<tr>
						<td>Filename:</td>
						<td>
							<xsl:value-of select="concat($fileName,'.xosdd')" />
						</td>
					</tr>
					<tr>
						<td>File MD5:</td>
						<td>
							<xsl:value-of select="$md5" />
						</td>
					</tr>
				</table>
				<h3>Test-Environment</h3>
				<table class="indented">
					<tr>
						<td>OSDD-Check version</td>
						<td>v1.5</td>
					</tr>
					<tr>
						<td>OSDD XML schema:</td>
						<td>v1.5</td>
					</tr>
				</table>
				<h3>Test-Results</h3>
				<table class="indented">
					<tr>
						<td>Nr. of Errors:</td>
						<xsl:if test="count(//svrl:failed-assert[@role='error']) 	!= 0">
							<td>
								<xsl:value-of select="count(//svrl:failed-assert[@role='error'])" />
							</td>
						</xsl:if>
						<xsl:if test="count(//svrl:failed-assert[@role='error']) 	= 0">
							<td>0 - The Validation was successful.</td>
						</xsl:if>
					</tr>
					<tr>
						<td>Nr. of Warnings:</td>
						<td>
							<xsl:value-of select="count(//svrl:failed-assert[@role='warning'])" />
						</td>
					</tr>
				</table>
				<h3>Detailed validation report:</h3>
				<xsl:if	test="$showReport and  count(//svrl:successful-report) != 0 or  $showWarning and count(//svrl:failed-assert[@role='warning']) != 0 or count(//svrl:failed-assert[@role='error']) != 0">
					<table width='100%' border="1">
						<tr>
							<td>
								<b>NR</b>
							</td>
							<td>
								<b>TYPE</b>
							</td>
							<td>
								<b>DESCRIPTION</b>
							</td>
							<td>
								<b>LINE</b>
							</td>
						</tr>
						<xsl:if test="count(//svrl:failed-assert[@role='error']) != 0">
							<tr>
								<td colspan="4">
									<b>ERRORS</b>
								</td>
							</tr>
							<xsl:for-each select="//svrl:failed-assert[@role='error']">
								<xsl:sort select="svrl:diagnostic-reference[@diagnostic='linenumber']" data-type="number" />
								<tr>
									<td>
										<xsl:value-of select="position()" />
									</td>
									<td>Error</td>
									<td>
										<xsl:value-of select="svrl:diagnostic-reference[@xml:lang='en']" />
									</td>
									<td>
										<xsl:value-of	select="svrl:diagnostic-reference[@diagnostic='linenumber']" />
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<xsl:if	test="$showWarning and count(//svrl:failed-assert[@role='warning']) != 0">
							<tr>
								<td colspan="4">
									<b>WARNINGS</b>
								</td>
							</tr>
							<xsl:for-each select="//svrl:failed-assert[@role='warning']">
								<xsl:sort select="svrl:diagnostic-reference[@diagnostic='linenumber']" data-type="number" />
								<tr>
									<td>
										<xsl:value-of select="position()" />
									</td>
									<td>Warning</td>
									<td>
										<xsl:value-of select="svrl:diagnostic-reference[@xml:lang='en']" />
									</td>
									<td>
										<xsl:value-of	select="svrl:diagnostic-reference[@diagnostic='linenumber']" />
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="$showReport and count(//svrl:successful-report) != 0">
							<tr>
								<td colspan="4">
									<b>REPORTS</b>
								</td>
							</tr>
							<xsl:for-each select="//svrl:successful-report">
								<xsl:sort select="svrl:diagnostic-reference[@diagnostic='linenumber']" data-type="number" />
								<tr>
									<td>
										<xsl:value-of select="position()" />
									</td>
									<td>Report</td>
									<td>
										<xsl:value-of select="svrl:diagnostic-reference[@xml:lang='en']" />
									</td>
									<td>
										<xsl:value-of	select="svrl:diagnostic-reference[@diagnostic='linenumber']" />
									</td>
								</tr>
							</xsl:for-each>
						</xsl:if>
					</table>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>