<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:myFunction="http://br-automation.com/customXSLTFunctions" xmlns:osdd="http://www.ethernet-powerlink.org/osdd" xmlns:saxon="http://saxon.sf.net/" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" version="2.0"><xsl:param name="archiveDirParameter"/><xsl:param name="archiveNameParameter"/><xsl:param name="fileNameParameter"/><xsl:param name="fileDirParameter"/><xsl:variable name="document-uri"><xsl:value-of select="document-uri(/)"/></xsl:variable><xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" indent="yes" method="xml" omit-xml-declaration="no" standalone="yes"/><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:checkFloat"><xsl:param as="xs:string" name="number"/><xsl:choose><xsl:when test="contains($number, '.')"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:calculateBitmask"><xsl:param as="xs:string" name="currentMask"/><xsl:choose><xsl:when test="$currentMask = '0x01'"><xsl:value-of select="1"/></xsl:when><xsl:when test="$currentMask = '0x02'"><xsl:value-of select="2"/></xsl:when><xsl:when test="$currentMask = '0x04'"><xsl:value-of select="3"/></xsl:when><xsl:when test="$currentMask = '0x08'"><xsl:value-of select="4"/></xsl:when><xsl:when test="$currentMask = '0x10'"><xsl:value-of select="5"/></xsl:when><xsl:when test="$currentMask = '0x20'"><xsl:value-of select="6"/></xsl:when><xsl:when test="$currentMask = '0x40'"><xsl:value-of select="7"/></xsl:when><xsl:when test="$currentMask = '0x80'"><xsl:value-of select="8"/></xsl:when></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:typeCheck"><xsl:param name="currentType"/><xsl:param name="value"/><xsl:choose><xsl:when test="string-length(string($value)) = 0"><xsl:value-of select="0"/></xsl:when><xsl:when test="string(number($value)) = 'NaN'"><xsl:value-of select="0"/></xsl:when><xsl:when test="$currentType = 'Boolean'"><xsl:choose><xsl:when test="xs:integer($value) = 0 or xs:integer($value) = 1"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int8'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED8_MIN and xs:integer($value) le $SIGNED8_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int16'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED16_MIN and xs:integer($value) le $SIGNED16_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int24'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED24_MIN and xs:integer($value) le $SIGNED24_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int32'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED32_MIN and xs:integer($value) le $SIGNED32_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int40'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED40_MIN and xs:integer($value) le $SIGNED40_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int48'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED48_MIN and xs:integer($value) le $SIGNED48_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int56'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED56_MIN and xs:integer($value) le $SIGNED56_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Int64'"><xsl:choose><xsl:when test="xs:integer($value) ge $SIGNED64_MIN and xs:integer($value) le $SIGNED64_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt8'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED8_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt16'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED16_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt24'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED24_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt32'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED32_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt40'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED40_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt48'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED48_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt56'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED56_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'UInt64'"><xsl:choose><xsl:when test="xs:integer($value) ge $ZERO and xs:integer($value) le $UNSIGNED64_MAX"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Float32'"><xsl:choose><xsl:when test="number($value) castable as xs:float"><xsl:value-of select="2"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Float64'"><xsl:choose><xsl:when test="number($value) castable as xs:double"><xsl:value-of select="2"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:when><xsl:when test="$currentType = 'Void'"><xsl:value-of select="0"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:typeSize"><xsl:param name="currentType"/><xsl:choose><xsl:when test="$currentType = 'Boolean'"><xsl:value-of select="0.125"/></xsl:when><xsl:when test="$currentType = 'Int8' or 'UInt8'"><xsl:value-of select="1"/></xsl:when><xsl:when test="$currentType = 'Int16' or 'UInt16'"><xsl:value-of select="2"/></xsl:when><xsl:when test="$currentType = 'Int24' or 'UInt24'"><xsl:value-of select="3"/></xsl:when><xsl:when test="$currentType = 'Int32' or 'UInt32' or 'Float32'"><xsl:value-of select="4"/></xsl:when><xsl:when test="$currentType = 'Int40' or 'UInt40'"><xsl:value-of select="5"/></xsl:when><xsl:when test="$currentType = 'Int48' or 'UInt48'"><xsl:value-of select="6"/></xsl:when><xsl:when test="$currentType = 'Int56' or 'UInt56'"><xsl:value-of select="7"/></xsl:when><xsl:when test="$currentType = 'Int64' or 'UInt64' or 'Float64'"><xsl:value-of select="8"/></xsl:when></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:SPDOoctetSize"><xsl:param name="size"/><xsl:choose><xsl:when test="number($size) &gt; 8"><xsl:value-of select="number($size) * 2 + 13"/></xsl:when><xsl:otherwise><xsl:value-of select="number($size) * 2 + 11"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:hex2dec"><xsl:param name="hex"/><xsl:choose><xsl:when test="string-length(string($hex)) = 0"><xsl:value-of select="'NaN'"/></xsl:when><xsl:when test="contains(string($hex), 'NaN')"><xsl:value-of select="'NaN'"/></xsl:when><xsl:when test="starts-with($hex, '0x')"><xsl:variable name="hexCorrected" select="translate($hex, 'abcdef', 'ABCDEF')"/><xsl:choose><xsl:when test="string-length($hexCorrected) = 1"><xsl:value-of select="myFunction:hexDigitToInteger($hexCorrected)"/></xsl:when><xsl:otherwise><xsl:value-of select="xs:integer(16 * (myFunction:hex2dec(substring($hexCorrected, 1, string-length($hexCorrected) - 1))) + myFunction:hexDigitToInteger(substring($hexCorrected, string-length($hexCorrected), 1)))"/></xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise><xsl:value-of select="xs:integer($hex)"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:hexDigitToInteger"><xsl:param name="char"/><xsl:value-of select="string-length(substring-before('0123456789ABCDEF', $char))"/></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:dec2hex"><xsl:param name="dec"/><xsl:choose><xsl:when test="starts-with(string($dec), '0x')"><xsl:value-of select="$dec"/></xsl:when><xsl:otherwise><xsl:choose><xsl:when test="number($dec) &lt; 16"><xsl:value-of select="myFunction:intToHexChar(number($dec))"/></xsl:when><xsl:otherwise><xsl:value-of select="concat(myFunction:dec2hex(floor(number($dec) div 16)), myFunction:intToHexChar(number($dec) mod 16))"/></xsl:otherwise></xsl:choose></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:intToHexChar"><xsl:param name="in"/><xsl:variable name="hexDigits" select="'0123456789ABCDEF'"/><xsl:value-of select="substring($hexDigits, (number($in) mod 16) + 1, 1)"/></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:dec2bin"><xsl:param name="dec"/><xsl:choose><xsl:when test="contains(string($dec), 'NaN')"><xsl:value-of select="'NaN'"/></xsl:when><xsl:when test="number($dec) = 0"><xsl:value-of select="'0'"/></xsl:when><xsl:when test="number($dec) = 1"><xsl:value-of select="'1'"/></xsl:when><xsl:otherwise><xsl:value-of select="concat(myFunction:dec2bin(floor(number($dec) div 2)), myFunction:dec2bin(number($dec) mod 2))"/></xsl:otherwise></xsl:choose></xsl:function><xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="myFunction:compareValues"><xsl:param name="in1"/><xsl:param name="in2"/><xsl:variable name="in1Converted"><xsl:choose><xsl:when test="starts-with($in1, '0x')"><xsl:value-of select="myFunction:hex2dec($in1)"/></xsl:when><xsl:otherwise><xsl:value-of select="number($in1)"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="in2Converted"><xsl:choose><xsl:when test="starts-with($in2, '0x')"><xsl:value-of select="myFunction:hex2dec($in2)"/></xsl:when><xsl:otherwise><xsl:value-of select="number($in2)"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:choose><xsl:when test="$in1Converted = 'NaN' or $in2Converted = 'NaN'"><xsl:value-of select="-2"/></xsl:when><xsl:when test="$in1Converted &lt; $in2Converted"><xsl:value-of select="-1"/></xsl:when><xsl:when test="$in1Converted &gt; $in2Converted"><xsl:value-of select="1"/></xsl:when><xsl:otherwise><xsl:value-of select="0"/></xsl:otherwise></xsl:choose></xsl:function><xsl:template match="*" mode="schematron-select-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="."/></xsl:template><xsl:template match="*" mode="schematron-get-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="parent::*"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''"><xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>*:</xsl:text><xsl:value-of select="local-name()"/><xsl:text>[namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose><xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/><xsl:text>[</xsl:text><xsl:value-of select="1+ $preceding"/><xsl:text>]</xsl:text></xsl:template><xsl:template match="@*" mode="schematron-get-full-path"><xsl:apply-templates mode="schematron-get-full-path" select="parent::*"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>@*[local-name()='</xsl:text><xsl:value-of select="local-name()"/><xsl:text>' and namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose></xsl:template><xsl:template match="node() | @*" mode="schematron-get-full-path-2"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><xsl:template match="node() | @*" mode="schematron-get-full-path-3"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="parent::*"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><xsl:template match="/" mode="generate-id-from-path"/><xsl:template match="text()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/></xsl:template><xsl:template match="comment()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/></xsl:template><xsl:template match="processing-instruction()" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/></xsl:template><xsl:template match="@*" mode="generate-id-from-path"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:value-of select="concat('.@', name())"/></xsl:template><xsl:template match="*" mode="generate-id-from-path" priority="-0.5"><xsl:apply-templates mode="generate-id-from-path" select="parent::*"/><xsl:text>.</xsl:text><xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/></xsl:template><xsl:template match="/" mode="generate-id-2">U</xsl:template><xsl:template match="*" mode="generate-id-2" priority="2"><xsl:text>U</xsl:text><xsl:number count="*" level="multiple"/></xsl:template><xsl:template match="node()" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number count="*" level="multiple"/><xsl:text>n</xsl:text><xsl:number count="node()"/></xsl:template><xsl:template match="@*" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number count="*" level="multiple"/><xsl:text>_</xsl:text><xsl:value-of select="string-length(local-name(.))"/><xsl:text>_</xsl:text><xsl:value-of select="translate(name(),':','.')"/></xsl:template><xsl:template match="text()" priority="-1"/><xsl:template match="/"><svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" schemaVersion="ISO19757-3" title="EPSG - openSAFETY Device Description checker output&#10;&#9;"><xsl:comment><xsl:value-of select="$archiveDirParameter"/>   <xsl:value-of select="$archiveNameParameter"/>  <xsl:value-of select="$fileNameParameter"/>  <xsl:value-of select="$fileDirParameter"/></xsl:comment><svrl:ns-prefix-in-attribute-values prefix="osdd" uri="http://www.ethernet-powerlink.org/osdd"/><svrl:ns-prefix-in-attribute-values prefix="xi" uri="http://www.w3.org/2001/XInclude"/><svrl:ns-prefix-in-attribute-values prefix="xlink" uri="http://www.w3.org/1999/xlink"/><svrl:ns-prefix-in-attribute-values prefix="xs" uri="http://www.w3.org/2001/XMLSchema"/><svrl:ns-prefix-in-attribute-values prefix="saxon" uri="http://saxon.sf.net/"/><svrl:ns-prefix-in-attribute-values prefix="exslt" uri="http://exslt.org/common"/><svrl:ns-prefix-in-attribute-values prefix="myFunction" uri="http://br-automation.com/customXSLTFunctions"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-module-definition-checks</xsl:attribute><xsl:attribute name="name">osdd-module-definition-checks</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M44" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-design-configuration-checks</xsl:attribute><xsl:attribute name="name">osdd-design-configuration-checks</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M45" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-module-settings-check</xsl:attribute><xsl:attribute name="name">osdd-module-settings-check</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M46" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-validation-settings-check</xsl:attribute><xsl:attribute name="name">osdd-validation-settings-check</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M47" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-visibility-settings-check</xsl:attribute><xsl:attribute name="name">osdd-visibility-settings-check</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M48" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-channel-configuration-settings-check</xsl:attribute><xsl:attribute name="name">osdd-channel-configuration-settings-check</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M49" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-data-type-checks</xsl:attribute><xsl:attribute name="name">osdd-data-type-checks</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M50" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-safe-motion-profile</xsl:attribute><xsl:attribute name="name">osdd-safe-motion-profile</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M51" select="/"/><svrl:active-pattern><xsl:attribute name="document"><xsl:value-of select="document-uri(/)"/></xsl:attribute><xsl:attribute name="id">osdd-vision-profile</xsl:attribute><xsl:attribute name="name">osdd-vision-profile</xsl:attribute><xsl:apply-templates/></svrl:active-pattern><xsl:apply-templates mode="M52" select="/"/></svrl:schematron-output></xsl:template><svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">EPSG - openSAFETY Device Description checker output</svrl:text><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED8_MAX" select="xs:integer(255)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED16_MAX" select="xs:integer(65535)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED24_MAX" select="xs:integer(16777215)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED32_MAX" select="xs:integer(4294967295)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED40_MAX" select="xs:integer(1099511627775)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED48_MAX" select="xs:integer(281474976710655)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED56_MAX" select="xs:integer(72057594037927935)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="UNSIGNED64_MAX" select="xs:integer(18446744073709551615)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="ZERO" select="xs:integer(0)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED8_MIN" select="xs:integer(-128)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED8_MAX" select="xs:integer(127)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED16_MIN" select="xs:integer(-32768)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED16_MAX" select="xs:integer(32767)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED24_MIN" select="xs:integer(-8388608)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED24_MAX" select="xs:integer(8388607)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED32_MIN" select="xs:integer(-2147483648)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED32_MAX" select="xs:integer(2147483647)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED40_MIN" select="xs:integer(-549755813888)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED40_MAX" select="xs:integer(549755813887)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED48_MIN" select="xs:integer(-140737488355328)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED48_MAX" select="xs:integer(140737488355327)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED56_MIN" select="xs:integer(-36028797018963968)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED56_MAX" select="xs:integer(36028797018963967)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED64_MIN" select="xs:integer(-9223372036854775808)"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="SIGNED64_MAX" select="xs:integer(9223372036854775807)"/><xsl:template match="/*" mode="M44" priority="1012"><xsl:choose><xsl:when test="starts-with(namespace-uri(),'http://www.ethernet-powerlink.org/osdd')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="starts-with(namespace-uri(),'http://www.ethernet-powerlink.org/osdd')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.schema.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The OSDD schema definition '<xsl:text/><xsl:value-of select="namespace-uri()"/><xsl:text/>' is not correct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.schema.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die OSDD Schema Definition '<xsl:text/><xsl:value-of select="namespace-uri()"/><xsl:text/>' ist nicht gültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Version) or matches(@Version,'^(\d(\.\d+)+)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Version) or matches(@Version,'^(\d(\.\d+)+)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.version.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The OSDD target version '<xsl:text/><xsl:value-of select="@Version"/><xsl:text/>' is invalid.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.version.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die OSDD Zielversion '<xsl:text/><xsl:value-of select="@Version"/><xsl:text/>' ist nicht gültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@Version)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Version)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.version.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The OSDD uses default value : '1.5'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.version.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die OSDD Version benutzt die Standardeinstellung : '1.5'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="count(//osdd:Module) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:Module) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulcount.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The OSDD has to contain at least one module description.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulcount.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die OSDD muss zumindest eine Modulbeschreibung enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module" mode="M44" priority="1011"><xsl:choose><xsl:when test="normalize-space(@id) != '' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id) != '' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'id' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'id' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentModuleID" select="string(@id)"/><xsl:variable name="currentMinSafetyRelease" select="string(@openSafetyRelease)"/><xsl:choose><xsl:when test="count(//osdd:Module[@id=$currentModuleID and @openSafetyRelease = $currentMinSafetyRelease]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:Module[@id=$currentModuleID and @openSafetyRelease = $currentMinSafetyRelease]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'id' : '<xsl:text/><xsl:value-of select="$currentModuleID"/><xsl:text/>' with 'openSafetyRelease' : '<xsl:text/><xsl:value-of select="$currentMinSafetyRelease"/><xsl:text/>' has to be unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'id' : '<xsl:text/><xsl:value-of select="$currentModuleID"/><xsl:text/>' mit 'openSafetyRelease' : '<xsl:text/><xsl:value-of select="$currentMinSafetyRelease"/><xsl:text/>' muss in der OSDD einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not($currentMinSafetyRelease = 'any') or count(//osdd:Module[@id=$currentModuleID]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($currentMinSafetyRelease = 'any') or count(//osdd:Module[@id=$currentModuleID]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.any.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'id' : '<xsl:text/><xsl:value-of select="$currentModuleID"/><xsl:text/>' is defined with any Safety release. Therefore no other 'Module' definition is allowed.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.id.any.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'id' : '<xsl:text/><xsl:value-of select="$currentModuleID"/><xsl:text/>' ist für jedem Safety Release definiert. Daher darf das Modul nicht mit einem anderen Safety Release definiert werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name) != '' and string(@Name) castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name) != '' and string(@Name) castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'Name' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'Name' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@openSafetyRelease) or matches(@openSafetyRelease,'^(1\.[3,4,5]|any)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@openSafetyRelease) or matches(@openSafetyRelease,'^(1\.[3,4,5]|any)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.minsafetyrelease.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'openSafetyRelease' : '<xsl:text/><xsl:value-of select="@openSafetyRelease"/><xsl:text/>' is invalid.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.minsafetyrelease.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'openSafetyRelease' : '<xsl:text/><xsl:value-of select="@openSafetyRelease"/><xsl:text/>' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@openSafetyRelease)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@openSafetyRelease)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.minsafetyrelease.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Module / minSafetyRelease attribute uses default value : '1.5'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.minsafetyrelease.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Module / minSafetyRelease Attribut benutzt die Standardeinstellung : '1.5'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:variable name="isSCMvalue"/><xsl:choose><xsl:when test="@isSCM='true' or (not(@isSCM) or @isSCM='false') and   count(//osdd:SettingsGroup[@CopyToAllSN='true' and ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) = 0   and   count(//osdd:ChannelGroup[@CopyToAllSN='true' and ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@isSCM='true' or (not(@isSCM) or @isSCM='false') and count(//osdd:SettingsGroup[@CopyToAllSN='true' and ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) = 0 and count(//osdd:ChannelGroup[@CopyToAllSN='true' and ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.isSCM.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Modul' attribute 'isSCM' : '<xsl:text/><xsl:value-of select="@isSCM"/><xsl:text/>' has to be set 'true' if a SettingsGroup or ChannelGroup has the 'CopyToAllSN' attribute set 'true'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modul.isSCM.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Modul' Attribut 'isSCM' : '<xsl:text/><xsl:value-of select="@isSCM"/><xsl:text/>' muss auf 'true' gesetzt sein wenn eine 'SettingsGroup' oder 'ChannelGroup' das 'CopyToAllSN' Attribute auf 'true' gesetzt hat.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@isSCM)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@isSCM)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.isscm.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Module / isSCM attribute uses default value : 'false'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.isscm.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Module / isSCM Attribut benutzt die Standardeinstellung : 'false'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(@isSCM='true' and count(//osdd:VendorInfo[ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) &gt;= 1)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@isSCM='true' and count(//osdd:VendorInfo[ancestor::osdd:Module[@id=$currentModuleID and @openSafetyRelease=$currentMinSafetyRelease]]) &gt;= 1)"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.module.isscm.vendor.info.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Please consider that vendor specific features may not be supported by every design tool.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.module.isscm.vendor.info.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Designtool unterstützt möglicherweise nicht alle herstellerspezifischen Features.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="//osdd:Description" mode="M44" priority="1010"><xsl:choose><xsl:when test="normalize-space(current()) != '' and string(.) castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(current()) != '' and string(.) castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.description.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Description' element must not be empty and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.description.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Description' Element darf nicht leer sein und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:Languages/osdd:Default" mode="M44" priority="1009"><xsl:choose><xsl:when test="matches(@CRC32,'^(0[xX][0-9a-fA-F]{8})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@CRC32,'^(0[xX][0-9a-fA-F]{8})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.default.crc32.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Default' attribute 'CRC32' : '<xsl:text/><xsl:value-of select="@CRC32"/><xsl:text/>' does not match the required format.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.default.crc32.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Default' Attribut 'CRC32' : '<xsl:text/><xsl:value-of select="@CRC32"/><xsl:text/>' hat ein falsches Format.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:Languages/osdd:Extern" mode="M44" priority="1008"><xsl:choose><xsl:when test="matches(@CRC32,'^(0[xX][0-9a-fA-F]{8})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@CRC32,'^(0[xX][0-9a-fA-F]{8})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.crc32.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Extern' attribute 'CRC32' : '<xsl:text/><xsl:value-of select="@CRC32"/><xsl:text/>' does not match the required format.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.crc32.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Extern' Attribut 'CRC32' : '<xsl:text/><xsl:value-of select="@CRC32"/><xsl:text/>' hat ein falsches Format.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Location) or matches(@Location,'.*\.xosdd')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Location) or matches(@Location,'.*\.xosdd')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.location.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Extern' attribute 'Location' : '<xsl:text/><xsl:value-of select="@Location"/><xsl:text/>' does not have the right file extension 'xosdd'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.location.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Extern' Attribut 'Location' : '<xsl:text/><xsl:value-of select="@Location"/><xsl:text/>' hat nicht die richtige Fileextension 'xosdd'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:Languages/osdd:Extern/xi:include" mode="M44" priority="1007"><xsl:choose><xsl:when test="matches(@href,'.*\.xosdd')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@href,'.*\.xosdd')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.href.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'xi:include' attribute 'href' : '<xsl:text/><xsl:value-of select="@href"/><xsl:text/>' does not have the right file extension 'xosdd'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.href.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'xi:include' Attribut 'href' : '<xsl:text/><xsl:value-of select="@href"/><xsl:text/>' hat nicht die richtige Fileextension 'xosdd'</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(@parse,'xml')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@parse,'xml')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.parse.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'xi:include' attribute 'parse' : '<xsl:text/><xsl:value-of select="@parse"/><xsl:text/>' does not match the prerequisites : 'xml'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.parse.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'xi:include' Attribut 'parse' : '<xsl:text/><xsl:value-of select="@parse"/><xsl:text/>' stimmt nicht mit den Vorraussetzungen überein : 'xml'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(..[@Location])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(..[@Location])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.locationcheck.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Location' is given in parent 'Extern' element. Therefore no import is possible.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.languages.extern.xi.include.locationcheck.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Da eine 'Location' im entsprechenden Parentelement 'Extern' gegeben ist, ist kein Import möglich.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:ModuleDefinition/osdd:DeviceInformation/osdd:VendorID" mode="M44" priority="1006"><xsl:choose><xsl:when test="matches(current(),'^([0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(current(),'^([0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.vendorid.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'VendorID' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' does not match the required format.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.vendorid.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'VendorID' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' hat ein falsches Format.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:ModuleDefinition/osdd:DeviceInformation/osdd:ProductCode" mode="M44" priority="1005"><xsl:choose><xsl:when test="normalize-space(current()) != '' and string(.) castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(current()) != '' and string(.) castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.productcode.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ProductCode' element must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.productcode.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ProductCode' Element muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:ModuleDefinition/osdd:DeviceInformation/osdd:Revision/osdd:Date" mode="M44" priority="1004"><xsl:choose><xsl:when test="string(.) castable as xs:dateTime"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(.) castable as xs:dateTime"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.revision.date.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Revision/Date' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' element has invalid format.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.revision.date.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Revision/Date' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element hat ein falsches Format.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:ModuleDefinition/osdd:DeviceInformation/osdd:Revision/osdd:Number" mode="M44" priority="1003"><xsl:choose><xsl:when test="matches(current(),'^(\d\.\d+(\.\d+)+)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(current(),'^(\d\.\d+(\.\d+)+)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.revision.number.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Revision/Number' : '<xsl:text/><xsl:value-of select="."/><xsl:text/> element has invalid format.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.moduldefinition.deviceinformation.revision.number.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Revision/Number' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element hat ein falsches Format.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:Module/osdd:ModuleDefinition/osdd:TimeConfiguration" mode="M44" priority="1002"><xsl:if test="count(./osdd:QuartzTolerance) eq 0"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:QuartzTolerance) eq 0"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.quartztolerance.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The TimeConfiguration / QuartzTolerance element uses default value : '50ppm'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.quartztolerance.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das TimeConfiguration / QuartzTolerance Element benutzt die Standardeinstellung : '50ppm'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ModuleDefinition/osdd:DataTransport/osdd:ACyclicTransport" mode="M44" priority="1001"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ACyclicTransport' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ACyclicTransport' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentName" select="string(@Name)"/><xsl:choose><xsl:when test="count(//osdd:SPDOTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0 and count(//osdd:ACyclicTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:DataTransport]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:SPDOTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0 and count(//osdd:ACyclicTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:DataTransport]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.name.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ACyclicTransport' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' element has to be unique within the 'Module'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.name.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ACyclicTransport' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' Element muss im 'Module' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(@Direction,'^(Input|Output|Both)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@Direction,'^(Input|Output|Both)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.direction.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ACyclicTransport' attribute 'Direction' : '<xsl:text/><xsl:value-of select="@Direction"/><xsl:text/> has to be either 'Input' or 'Output' or 'Both'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.direction.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ACyclicTransport' Attribut 'Direction' : '<xsl:text/><xsl:value-of select="@Direction"/><xsl:text/>' muss entweder 'Input' oder 'Output' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="string(@OctetSize) castable as xs:integer and @OctetSize &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@OctetSize) castable as xs:integer and @OctetSize &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.octetsize.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ACyclicTransport' attribute 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' has to be a positive Integer.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.octetsize.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ACyclicTransport' Attribut 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' muss ein positiver Integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSize" select="number(@OctetSize)"/><xsl:choose><xsl:when test="$currentSize mod 2 &gt; 0 and ($currentSize &gt;= 11 and $currentSize &lt;= 27 or $currentSize &gt;= 31 and $currentSize &lt;= 521)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$currentSize mod 2 &gt; 0 and ($currentSize &gt;= 11 and $currentSize &lt;= 27 or $currentSize &gt;= 31 and $currentSize &lt;= 521)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.octetsize.frame.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ACyclicTransport' with 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' does not fit in an openSAFETY frame.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.acyclictransport.octetsize.frame.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'ACyclicTransport' mit 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' hat die falsche Größe für einen openSAFETY Frame.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ModuleDefinition/osdd:DataTransport/osdd:CrossMapping" mode="M44" priority="1000"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(//osdd:CrossMapping[@Direction='Both' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:CrossMapping[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    or count(//osdd:CrossMapping[@Direction='Input' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:CrossMapping[@Direction='Output' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    or count(//osdd:CrossMapping[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:CrossMapping[@Direction='Both' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:CrossMapping[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:CrossMapping[@Direction='Input' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:CrossMapping[@Direction='Output' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:CrossMapping[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.crossmapping.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Only one CrossMapping entry per direction or one with direction 'Both' is allowed.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.crossmapping.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Es ist nur ein CrossMapping Element pro Direction oder eines mit Direction 'Both' erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="text()" mode="M44" priority="-1"/><xsl:template match="@*|node()" mode="M44" priority="-2"><xsl:apply-templates mode="M44" select="*"/></xsl:template><xsl:template match="*/osdd:DesignConfiguration/osdd:SettingDataTemplates/osdd:Choice" mode="M45" priority="1003"><xsl:variable name="current" select="string(./@id)"/><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(//osdd:Choice[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:Range[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:Choice[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:Range[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' template : '<xsl:text/><xsl:value-of select="$current"/><xsl:text/>' must not exist multiple times.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Choice' Template : '<xsl:text/><xsl:value-of select="$current"/><xsl:text/>' Element darf nicht mehrere Male existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@id)!='' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id)!='' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Choice' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' attribute 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' has to be an OSDD data type ('Void' is not allowed).</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Choice' Attribut 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' muss ein OSDD Datentyp sein ('Void' ist nicht erlaubt).</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Unit) or @Unit castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Unit) or @Unit castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' attribute 'Unit' : '<xsl:text/><xsl:value-of select="@Unit"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Choice' Attribut 'Unit' : '<xsl:text/><xsl:value-of select="@Unit"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@Unit)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Unit)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.choice.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Choice attribute Unit uses default value : ' '.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.choice.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Choice Attribut Unit benutzt die Standardeinstellung: ' '.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="count(./osdd:Entry) &gt; 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Entry) &gt; 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' element has to include more than one entry.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Choice' Element muss mehr als ein 'Entry' Element enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M45" select="*"/></xsl:template><xsl:template match="*/osdd:DesignConfiguration/osdd:SettingDataTemplates/osdd:Choice/osdd:Entry" mode="M45" priority="1002"><xsl:choose><xsl:when test="normalize-space(@Value) != &quot;&quot; and @Value castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@Value) != &quot;&quot; and @Value castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Entry' attribute 'Value' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Entry' Attribut 'Value' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Display) or normalize-space(@Display) !='' and @Display castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Display) or normalize-space(@Display) !='' and @Display castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.display.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Entry' attribute 'Display' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.choice.entry.display.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Entry' Attribut 'Display' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(./@Display or ../@Unit)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./@Display or ../@Unit)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.entry.display.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Entry' / 'Display' or 'Choice' / 'Unit' is recommended.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.entry.display.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder 'Entry' / 'Display' oder 'Choice' / 'Unit' wird empfohlen.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M45" select="*"/></xsl:template><xsl:template match="*/osdd:DesignConfiguration/osdd:SettingDataTemplates/osdd:Range" mode="M45" priority="1001"><xsl:variable name="current" select="string(./@id)"/><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(//osdd:Range[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:Choice[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:Range[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:Choice[@id=$current and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.name.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' template : '<xsl:text/><xsl:value-of select="./@Name"/><xsl:text/>' has to be unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.name.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Range' Template: '<xsl:text/><xsl:value-of select="$current"/><xsl:text/>' muss im 'Module' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@id) != '' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id) != '' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' attribute 'Name' : '<xsl:text/><xsl:value-of select="$current"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Range' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(@Type,'^(UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@Type,'^(UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' attribute 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' has to be an unsigned integer OSDD data type.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Range' Attribut 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' muss ein vorzeichenloser Integer OSDD Datentyp sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Unit) or @Unit castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Unit) or @Unit castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' attribute 'Unit' : '<xsl:text/><xsl:value-of select="@Unit"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.range.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Range' Attribut 'Unit' : '<xsl:text/><xsl:value-of select="@Unit"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@Unit)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Unit)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.range.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Range attribute Unit uses default value : ' '.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.range.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Range Attribut Unit benutzt die Standardeinstellung: ' '.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M45" select="*"/></xsl:template><xsl:template match="*/osdd:DesignConfiguration/osdd:SettingDataTemplates/osdd:Range/osdd:RangeDefinition" mode="M45" priority="1000"><xsl:choose><xsl:when test="./@RangeMin castable as xs:integer and number(./@RangeMin) &gt;= 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./@RangeMin castable as xs:integer and number(./@RangeMin) &gt;= 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.rangemin.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'RangeDefinition' attribute 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' must have a value greater or equal zero and has to have data type xs:integer.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.rangemin.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'RangeDefinition' Attribut 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' muss einen Wert größer gleich Null haben und muss vom Datentyp xs:integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="number(@RangeMin) &lt; number(@RangeMax)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="number(@RangeMin) &lt; number(@RangeMax)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.minmax.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'RangeDefinition' attribute 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' has to be smaller than the 'RangeDefinition' attribute 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.minmax.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'RangeDefinition' Attribut 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' muss kleiner sein als das 'RangeDefinition' Attribut 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./@RangeMax castable as xs:integer and number(./@RangeMax) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./@RangeMax castable as xs:integer and number(./@RangeMax) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.rangemax.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'RangeDefinition' attribute 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>' must have a value greater zero and has to have data type xs:integer.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.rangemax.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'RangeDefinition' Attribut 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>' muss einen Wert größer Null haben und muss vom Datentyp xs:integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@StepSize) or ./@StepSize castable as xs:integer and number(@StepSize) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@StepSize) or ./@StepSize castable as xs:integer and number(@StepSize) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.stepsize.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'RangeDefinition' attribute 'StepSize' : '<xsl:text/><xsl:value-of select="@StepSize"/><xsl:text/>' must have a value greater zero and has to have data type xs:integer.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.designconfiguration.settingdatatemplates.rangedefinition.stepsize.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'RangeDefinition' Attribut 'StepSize' : '<xsl:text/><xsl:value-of select="@StepSize"/><xsl:text/>' muss einen Wert größer Null haben und muss vom Datentyp xs:integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(./@StepSize)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./@StepSize)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.rangedefinition.stepsize.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The RangeDefinition / StepSize attribute uses default value : '1'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.rangedefinition.stepsize.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das RangeDefinition / StepSize Attribut benutzt die Standardeinstellung : '1'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(./@StepSize) or (number(./@RangeMax) - number(./@RangeMin)) mod number(./@StepSize) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./@StepSize) or (number(./@RangeMax) - number(./@RangeMin)) mod number(./@StepSize) = 0"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.designconfiguration.settingdatatemplates.rangedefinition.stepsize.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'RangeDefinition' can not be reached with given 'StepSize'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.designconfiguration.settingdatatemplates.rangedefinition.stepsize.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'RangeDefinition' kann mit der gegebenen 'StepSize' nicht erreicht werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M45" select="*"/></xsl:template><xsl:template match="text()" mode="M45" priority="-1"/><xsl:template match="@*|node()" mode="M45" priority="-2"><xsl:apply-templates mode="M45" select="*"/></xsl:template><xsl:template match="*/osdd:ModuleSettings/osdd:SettingsGroup" mode="M46" priority="1007"><xsl:choose><xsl:when test="normalize-space(@id)!='' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id)!='' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' Attribut 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSettingsGroup" select="string(./@id)"/><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="@ActiveInFunction or count(//osdd:SettingsGroup[@id=$currentSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@ActiveInFunction or count(//osdd:SettingsGroup[@id=$currentSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' : '<xsl:text/><xsl:value-of select="$currentSettingsGroup"/><xsl:text/>' must not exist multiple times.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' : '<xsl:text/><xsl:value-of select="$currentSettingsGroup"/><xsl:text/>' Element darf nicht mehrere Male existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSettingsGroup" select="string(./@id)"/><xsl:variable name="currentActiveInFunction" select="string(./@ActiveInFunction)"/><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@ActiveInFunction) or count(//osdd:SettingsGroup[@id=$currentSettingsGroup and @ActiveInFunction=$currentActiveInFunction and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@ActiveInFunction) or count(//osdd:SettingsGroup[@id=$currentSettingsGroup and @ActiveInFunction=$currentActiveInFunction and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' : '<xsl:text/><xsl:value-of select="$currentSettingsGroup"/><xsl:text/>' must not exist multiple times.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.id.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' : '<xsl:text/><xsl:value-of select="$currentSettingsGroup"/><xsl:text/>' Element darf nicht mehrere Male existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@CopyFromChannel) or @CopyFromChannel='none' or count(descendant::osdd:Setting) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@CopyFromChannel) or @CopyFromChannel='none' or count(descendant::osdd:Setting) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.copy.empty.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' copies its settings from a channel but is not empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.copy.empty.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'SettingsGroup' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' kopiert alle Einstellungen von einem Kanal aber ist nicht leer.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@CopyFromChannel)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@CopyFromChannel)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.copyfromchannel.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The SettingsGroup attribute CopyFromChannel uses default value : 'none'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.copyfromchannel.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das SettingsGroup Attribute CopyFromChannel benutzt die Standardeinstellung: 'none'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="channelgroup" select="tokenize(@CopyFromChannel, '/')[position() = 1]"/><xsl:variable name="channel" select="tokenize(@CopyFromChannel, '/')[last()]"/><xsl:variable name="countChannelGroup" select="count(//osdd:ChannelGroup[@id=$channelgroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="countChannel" select="count(//osdd:Channel[@id=$channel and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="ChannelSettingExist" select="count(//osdd:Channel[@id=$channel and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:ChannelSettings)"/><xsl:choose><xsl:when test="not(@CopyFromChannel) or @CopyFromChannel='none' or $countChannelGroup = 1 and ($countChannel = 1 and $ChannelSettingExist = 1)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@CopyFromChannel) or @CopyFromChannel='none' or $countChannelGroup = 1 and ($countChannel = 1 and $ChannelSettingExist = 1)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.copyfromchannel.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' attribute 'CopyFromChannel' : '<xsl:text/><xsl:value-of select="$channelgroup"/><xsl:text/>/<xsl:text/><xsl:value-of select="$channel"/><xsl:text/>' is not valid or channel does not have 'ChannelSettings' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.copyfromchannel.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' Attribut 'CopyFromChannel' : '<xsl:text/><xsl:value-of select="$channelgroup"/><xsl:text/>/<xsl:text/><xsl:value-of select="$channel"/><xsl:text/>' ist nicht gültig oder der Kanal hat keine 'ChannelSetting' element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@MinRole) or matches(@MinRole,'^(Development|Commissioning|Maintenance)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@MinRole) or matches(@MinRole,'^(Development|Commissioning|Maintenance)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.minrole.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SettingsGroup' attribute 'MinRole' : '<xsl:text/><xsl:value-of select="@MinRole"/><xsl:text/>' does not match the predefined values : Development|Commissioning|Maintenance.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.modulesettings.settingsgroup.minrole.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SettingsGroup' Attribut 'MinRole' : '<xsl:text/><xsl:value-of select="@MinRole"/><xsl:text/>' Element hat nicht einen der vorgegeben Werte : Development|Commissioning|Maintenance.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@CopyToAllSN)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@CopyToAllSN)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.settingsgroup.copytoallsn.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The SettingsGroup / CopyToAllSN attribute uses default value : 'false'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.settingsgroup.copytoallsn.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Setting / CopyToAllSN Attribut benutzt die Standardeinstellung : 'false'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:if test="not(@MinRole)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@MinRole)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.settingsgroup.minrole.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The SettingsGroup / MinRole attribute uses default value : 'Development'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.settingsgroup.minrole.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das SettingsGroup / MinRole Attribut benutzt die Standardeinstellung : 'Development'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Setting" mode="M46" priority="1006"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="normalize-space(@id)!='' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id)!='' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' Attribut 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSettingID" select="string(./@id)"/><xsl:choose><xsl:when test="ancestor::osdd:Module[@isSCM='true' and @id=$currentModule and @openSafetyRelease=$currentSafetyRelease] or    count(//osdd:Setting[@id=$currentSettingID and not(../osdd:ActiveInFunction) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    or ../osdd:ActiveInFunction and    (every $function in ../osdd:ActiveInFunction/osdd:FunctionReference satisfies count(//osdd:Setting[@id=$currentSettingID and ../osdd:ActiveInFunction/osdd:FunctionReference[@id=$function/@id] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="ancestor::osdd:Module[@isSCM='true' and @id=$currentModule and @openSafetyRelease=$currentSafetyRelease] or count(//osdd:Setting[@id=$currentSettingID and not(../osdd:ActiveInFunction) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or ../osdd:ActiveInFunction and (every $function in ../osdd:ActiveInFunction/osdd:FunctionReference satisfies count(//osdd:Setting[@id=$currentSettingID and ../osdd:ActiveInFunction/osdd:FunctionReference[@id=$function/@id] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.id.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' : '<xsl:text/><xsl:value-of select="$currentSettingID"/><xsl:text/>' must not exist multiple times.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.id.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' : '<xsl:text/><xsl:value-of select="$currentSettingID"/><xsl:text/>' Element darf nicht mehrere Male existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Type) or matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Type) or matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' attribute 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' has to be an OSDD data type ('Void' is not allowed).</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' Attribut 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' muss ein OSDD Datentyp sein ('Void' ist nicht erlaubt).</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Type) or not(@Template)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Type) or not(@Template)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.templatetype.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' : 'Type' element and the 'Setting' : 'Template' element must not appear in the same 'Setting'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.templatetype.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' : 'Type' Element und das 'Setting' : 'Template' Element darf nicht im selben 'Setting' existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Type) or ./osdd:DataSelection or @Type and @Value"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Type) or ./osdd:DataSelection or @Type and @Value"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.typevalue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' element must contain a 'Type' and a 'Value' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.typevalue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' Element muss ein 'Type' und ein 'Value' Element enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentTemplate" select="@Template"/><xsl:variable name="currentValue" select="@Value"/><xsl:choose><xsl:when test="not(@Template) or count(//osdd:Choice[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Entry[@Value=$currentValue]) = 1 or count(//osdd:Range[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Template) or count(//osdd:Choice[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Entry[@Value=$currentValue]) = 1 or count(//osdd:Range[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.template.entry.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' : '<xsl:text/><xsl:value-of select="$currentTemplate"/><xsl:text/>' element does not have an 'Entry' with 'Value' : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.template.entry.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'Choice' : '<xsl:text/><xsl:value-of select="$currentTemplate"/><xsl:text/>' hat kein 'Entry' Element mit 'Value' : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>' Attribut.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentTemplate" select="@Template"/><xsl:variable name="currentValue" select="@Value"/><xsl:variable name="currentChoice" select="count(//osdd:Choice[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="currentRangeCount" select="count(//osdd:Range[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="currentRange" select="//osdd:Range[@id=$currentTemplate and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]][1]"/><xsl:variable name="currentMaxVal" select="$currentRange/osdd:RangeDefinition/@RangeMax"/><xsl:variable name="currentMinVal" select="$currentRange/osdd:RangeDefinition/@RangeMin"/><xsl:variable name="currentStepSize" select="$currentRange/osdd:RangeDefinition/@StepSize"/><xsl:variable name="currentCalc" select="$currentMaxVal - $currentValue"/><xsl:choose><xsl:when test="not(@Template) or number($currentChoice) = 1 or number($currentRangeCount) = 1 and number($currentCalc) &gt;= 0 and number($currentValue) &gt;= number($currentMinVal) and (not($currentRange/osdd:RangeDefinition/@StepSize) or number($currentCalc) mod number($currentStepSize) = 0)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Template) or number($currentChoice) = 1 or number($currentRangeCount) = 1 and number($currentCalc) &gt;= 0 and number($currentValue) &gt;= number($currentMinVal) and (not($currentRange/osdd:RangeDefinition/@StepSize) or number($currentCalc) mod number($currentStepSize) = 0)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.template.range.entry.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' : '<xsl:text/><xsl:value-of select="$currentTemplate"/><xsl:text/>' element does not include a valid 'Value' : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.template.range.entry.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'Range' : '<xsl:text/><xsl:value-of select="$currentTemplate"/><xsl:text/>' hat keinen gültigen 'Value' : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Visibility) or matches(@Visibility,'^(None|Overall|ReadOnly|SafetyOnly)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Visibility) or matches(@Visibility,'^(None|Overall|ReadOnly|SafetyOnly)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.visibility.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' attribute 'Visibility' : '<xsl:text/><xsl:value-of select="@Visibility"/><xsl:text/>' does not match the predefined values : None|Overall|ReadOnly|SafetyOnly</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.visibility.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' Attribut 'Visibility' : '<xsl:text/><xsl:value-of select="@Visibility"/><xsl:text/>' Element hat nicht einen der vorgegeben Werte : None|Overall|ReadOnly|SafetyOnly.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Visibility) or not(matches(@Visibility,'^(None)$') and descendant::osdd:ParameterStream)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Visibility) or not(matches(@Visibility,'^(None)$') and descendant::osdd:ParameterStream)"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.visibility.sodposition.parameterstream.en"><xsl:attribute name="xml:lang">en</xsl:attribute>If 'Setting' has attribute 'Visibility' : '<xsl:text/><xsl:value-of select="@Visibility"/><xsl:text/>' the setting must not contain a ParameterStream element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.visibility.sodposition.parameterstream.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Wenn ein 'Setting' das Attribute 'Visibility' auf '<xsl:text/><xsl:value-of select="@Visibility"/><xsl:text/>' gesetzt hat darf es kein 'ParameterStream' Element enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@Visibility)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Visibility)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.setting.visibility.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Setting / Visibility attribute uses default value : 'Overall'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.setting.visibility.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Setting / Visibility Attribut benutzt die Standardeinstellung : 'Overall'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(@MinRole)    or matches(@MinRole,'^(Development|Commissioning|Maintenance)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@MinRole) or matches(@MinRole,'^(Development|Commissioning|Maintenance)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.minrole.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' attribute 'MinRole' : '<xsl:text/><xsl:value-of select="@MinRole"/><xsl:text/>' does not match the predefined values : Development|Commissioning|Maintenance.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.minrole.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' Attribut 'MinRole' : '<xsl:text/><xsl:value-of select="@MinRole"/><xsl:text/>' Element hat nicht einen der vorgegeben Werte : Development|Commissioning|Maintenance.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@MinRole)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@MinRole)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.setting.minrole.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Setting / MinRole element uses default value : 'Development'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.setting.minrole.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Setting / MinRole Attribut benutzt die Standardeinstellung : 'Development'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(./osdd:DataSelection) or not(./@Template or ./@Type)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:DataSelection) or not(./@Template or ./@Type)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.check.dataselection.dependencies.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' has a 'DataSelection' child element and therefore may not have 'Template' or 'Value' or 'Type' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.check.dataselection.dependencies.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' hat ein 'DataSelection' Kindelement und darf daher kein 'Template' oder 'Value' oder 'Type' Attribut beinhalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./osdd:DataSelection and @id or @id and  @Template and @Value or @id and @Value and @Type"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:DataSelection and @id or @id and @Template and @Value or @id and @Value and @Type"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.single.line.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' has to include either the attributes 'id', 'Value' and 'Type' or 'id', 'Template' and 'Value'  or a 'id' and 'DataSelection'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.single.line.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' muss die Attribute 'id', 'Value' und Type  oder 'id', 'Template' und 'Value' oder 'id' und 'DataSelection' enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentTypeNormal" select="@Type"/><xsl:variable name="currentTypeDataSelection" select="./osdd:DataSelection/@Type"/><xsl:variable name="currentTemplate" select="string(@Template)"/><xsl:variable name="currentTypeTemplate" select="//*[@id=$currentTemplate    and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]][1]/@Type"/><xsl:choose><xsl:when test="every $param in descendant::osdd:Value satisfies $param/../osdd:Parameter or count(//$param/../osdd:Value) = 2    or myFunction:typeCheck($currentTypeNormal,$param) = 1    or myFunction:typeCheck($currentTypeDataSelection,$param) = 1    or myFunction:typeCheck($currentTypeTemplate,$param) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $param in descendant::osdd:Value satisfies $param/../osdd:Parameter or count(//$param/../osdd:Value) = 2 or myFunction:typeCheck($currentTypeNormal,$param) = 1 or myFunction:typeCheck($currentTypeDataSelection,$param) = 1 or myFunction:typeCheck($currentTypeTemplate,$param) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.value.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>One or more child 'Value' elements does not fit the parent 'Setting' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' data type or template.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.value.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein oder mehrere 'Value' Kindelement des 'Settings' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' nicht mit dem Datentyp oder Template überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Value" mode="M46" priority="1005"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="currentParameter" select="../osdd:Parameter"/><xsl:variable name="currentSettingsGroup" select="$currentParameter/@SettingsGroup"/><xsl:variable name="currentChannelGroupCopyFromChannel" select="(//osdd:SettingsGroup[@id=$currentSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@CopyFromChannel"/><xsl:variable name="channelgroup" select="tokenize($currentChannelGroupCopyFromChannel, '/')[position() = 1]"/><xsl:variable name="channel" select="tokenize($currentChannelGroupCopyFromChannel, '/')[last()]"/><xsl:variable name="channelsetting" select="(//osdd:Setting[@id=$currentParameter and ancestor::*[@id=$channel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]"/><xsl:variable name="currentTypeNormalChannel" select="$channelsetting/@Type"/><xsl:variable name="currentTypeDataSelectionChannel" select="$channelsetting/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplateChannel" select="string($channelsetting/@Template)"/><xsl:variable name="currentTypeTemplateChannel" select="(//*[@id=$currentTemplateChannel and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentTypeNormal" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentTypeDataSelection" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplate" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Template"/><xsl:variable name="currentTypeTemplate" select="(//*[@id=$currentTemplate and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="count_setting_param" select="count(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_setting_channel" select="count(//osdd:Setting[@id=$currentParameter and ancestor::*[@id=$channel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="    not(./../osdd:Parameter)    or myFunction:typeCheck($currentTypeNormal,.) = 1    and $count_setting_param &gt;= 1    and $count_setting_channel = 0     or myFunction:typeCheck($currentTypeDataSelection,.) = 1    and $count_setting_param &gt;= 1    and $count_setting_channel = 0     or myFunction:typeCheck($currentTypeTemplate,.) = 1    and $count_setting_param &gt;= 1    and $count_setting_channel = 0     or myFunction:typeCheck($currentTypeNormalChannel,.) = 1    and $count_setting_channel = 1     or myFunction:typeCheck($currentTypeDataSelectionChannel,.) = 1    and $count_setting_channel = 1     or myFunction:typeCheck($currentTypeTemplateChannel,.) = 1    and $count_setting_channel = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./../osdd:Parameter) or myFunction:typeCheck($currentTypeNormal,.) = 1 and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or myFunction:typeCheck($currentTypeDataSelection,.) = 1 and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or myFunction:typeCheck($currentTypeTemplate,.) = 1 and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or myFunction:typeCheck($currentTypeNormalChannel,.) = 1 and $count_setting_channel = 1 or myFunction:typeCheck($currentTypeDataSelectionChannel,.) = 1 and $count_setting_channel = 1 or myFunction:typeCheck($currentTypeTemplateChannel,.) = 1 and $count_setting_channel = 1"><xsl:attribute name="role">warning</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.value.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' childelement does not fit the parent 'Setting' or parent 'Parameter' data type.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.value.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Kindelement des 'Settings' stimmt nicht mit dem übergeordneten 'Setting' oder 'Parameter' Datentyp überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="currentSetting" select="ancestor::osdd:Setting/@id"/><xsl:variable name="currentTypeNormalVal" select="ancestor::osdd:Setting/@Type"/><xsl:variable name="currentTypeDataSelectionVal" select="ancestor::osdd:Setting/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplateVal" select="ancestor::osdd:Setting/@Template"/><xsl:variable name="currentTypeTemplateVal" select="(//*[@id=$currentTemplateVal and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:choose><xsl:when test="   not(count(./../*) = 1)   or myFunction:typeCheck($currentTypeNormalVal,.) = 1   or myFunction:typeCheck($currentTypeDataSelectionVal,.) = 1   or myFunction:typeCheck($currentTypeTemplateVal,.) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(count(./../*) = 1) or myFunction:typeCheck($currentTypeNormalVal,.) = 1 or myFunction:typeCheck($currentTypeDataSelectionVal,.) = 1 or myFunction:typeCheck($currentTypeTemplateVal,.) = 1"><xsl:attribute name="role">warning</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.single.value.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The standalone 'Value' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' childelement does not fit the parent 'Setting' or parent 'Parameter' data type.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.single.value.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der Standalone 'Value' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element Datentyp stimmt nicht mit dem übergeordneten 'Setting' oder mit dem Vergleichsparameter Datentyp überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Parameter" mode="M46" priority="1004"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="currentfirstParam" select="."/><xsl:variable name="siblingIsSame" select="count(./../osdd:Parameter[text() = string($currentfirstParam)])"/><xsl:variable name="currentfirstTypeNormal" select="(//osdd:Setting[@id=$currentfirstParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentfirstTypeDataSelection" select="(//osdd:Setting[@id=$currentfirstParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/osdd:DataSelection/@Type"/><xsl:variable name="currentfirstTemplate" select="(//osdd:Setting[@id=$currentfirstParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Template"/><xsl:variable name="currentfirstTypeTemplate" select="(//*[@id=$currentfirstTemplate and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentfirstSettingsGroup" select="$currentfirstParam/@SettingsGroup"/><xsl:variable name="currentfirstChannelGroupCopyFromChannel" select="(//osdd:SettingsGroup[@id=$currentfirstSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@CopyFromChannel"/><xsl:variable name="firstchannelgroup" select="tokenize($currentfirstChannelGroupCopyFromChannel, '/')[position() = 1]"/><xsl:variable name="firstchannel" select="tokenize($currentfirstChannelGroupCopyFromChannel, '/')[last()]"/><xsl:variable name="firstchannelsetting" select="(//osdd:Setting[@id=$currentfirstParam and ancestor::*[@id=$firstchannel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]"/><xsl:variable name="currentfirstTypeNormalChannel" select="$firstchannelsetting/@Type"/><xsl:variable name="currentfirstTypeDataSelectionChannel" select="$firstchannelsetting/osdd:DataSelection/@Type"/><xsl:variable name="currentfirstTemplateChannel" select="string($firstchannelsetting/@Template)"/><xsl:variable name="currentfirstTypeTemplateChannel" select="(//*[@id=$currentfirstTemplateChannel and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentsecondParam" select="./../osdd:Parameter[text() != string($currentfirstParam)]"/><xsl:variable name="currentsecondTypeNormal" select="(//osdd:Setting[@id=$currentsecondParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentsecondTypeDataSelection" select="(//osdd:Setting[@id=$currentsecondParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/osdd:DataSelection/@Type"/><xsl:variable name="currentsecondTemplate" select="(//osdd:Setting[@id=$currentsecondParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Template"/><xsl:variable name="currentsecondTypeTemplate" select="(//*[@id=$currentsecondTemplate and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentsecondSettingsGroup" select="$currentsecondParam/@SettingsGroup"/><xsl:variable name="currentsecondChannelGroupCopyFromChannel" select="(//osdd:SettingsGroup[@id=$currentsecondSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@CopyFromChannel"/><xsl:variable name="secondchannelgroup" select="tokenize($currentsecondChannelGroupCopyFromChannel, '/')[position() = 1]"/><xsl:variable name="secondchannel" select="tokenize($currentsecondChannelGroupCopyFromChannel, '/')[last()]"/><xsl:variable name="secondchannelsetting" select="(//osdd:Setting[@id=$currentsecondParam and ancestor::*[@id=$secondchannel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]"/><xsl:variable name="currentsecondTypeNormalChannel" select="$secondchannelsetting/@Type"/><xsl:variable name="currentsecondTypeDataSelectionChannel" select="$secondchannelsetting/osdd:DataSelection/@Type"/><xsl:variable name="currentsecondTemplateChannel" select="string($secondchannelsetting/@Template)"/><xsl:variable name="currentsecondTypeTemplateChannel" select="(//*[@id=$currentsecondTemplateChannel and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="count_first_setting_param" select="count(//osdd:Setting[@id=$currentfirstParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_first_setting_channel" select="count(//osdd:Setting[@id=$currentfirstParam and ancestor::*[@id=$firstchannel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_second_setting_param" select="count(//osdd:Setting[@id=$currentsecondParam and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_second_setting_channel" select="count(//osdd:Setting[@id=$currentsecondParam and ancestor::*[@id=$secondchannel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="not($siblingIsSame = 2)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($siblingIsSame = 2)"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.setting.conditions.parameter.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' is compared to itself.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.setting.conditions.parameter.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' wird mit sich selbst verglichen.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(count(./../osdd:Parameter) = 2) or $siblingIsSame = 2    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeNormal),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeNormal) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeDataSelection),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeDataSelection) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeTemplate),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeTemplate) != ''    and $count_first_setting_param &gt;= 1    and $count_first_setting_channel = 0    and $count_second_setting_channel = 1     or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeNormalChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1     or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1     or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_param &gt;= 1    and $count_second_setting_channel = 0    or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    or    compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeTemplateChannel) != ''    and $count_first_setting_channel = 1    and $count_second_setting_channel = 1    "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(count(./../osdd:Parameter) = 2) or $siblingIsSame = 2 or compare(string($currentfirstTypeNormal),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormal),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormal),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormal),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeNormal),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeNormal),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeNormal) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelection),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeDataSelection) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplate),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeTemplate) != '' and $count_first_setting_param &gt;= 1 and $count_first_setting_channel = 0 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeNormalChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeNormalChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeDataSelectionChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeDataSelectionChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeNormal)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeDataSelection)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeTemplate)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_param &gt;= 1 and $count_second_setting_channel = 0 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeNormalChannel)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeDataSelectionChannel)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1 or compare(string($currentfirstTypeTemplateChannel),string($currentsecondTypeTemplateChannel)) = 0 and string($currentfirstTypeTemplateChannel) != '' and $count_first_setting_channel = 1 and $count_second_setting_channel = 1"><xsl:attribute name="role">warning</xsl:attribute><svrl:text><xsl:text/><xsl:value-of select="$siblingIsSame"/><xsl:text/></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.parameter.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' does not fit the sibling 'Parameter' data type.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.parameter.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element Datentyp stimmt nicht mit dem Datentyp des Vergleichsparameters überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSetting" select="ancestor::osdd:Setting/@id"/><xsl:variable name="currentTypeNormalVal" select="ancestor::osdd:Setting/@Type"/><xsl:variable name="currentTypeDataSelectionVal" select="ancestor::osdd:Setting/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplateVal" select="ancestor::osdd:Setting/@Template"/><xsl:variable name="currentTypeTemplateVal" select="(//*[@id=$currentTemplateVal and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentParameter" select="."/><xsl:variable name="currentSettingsGroup" select="$currentParameter/@SettingsGroup"/><xsl:variable name="currentChannelGroupCopyFromChannel" select="(//osdd:SettingsGroup[@id=$currentSettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@CopyFromChannel"/><xsl:variable name="channelgroup" select="tokenize($currentChannelGroupCopyFromChannel, '/')[position() = 1]"/><xsl:variable name="channel" select="tokenize($currentChannelGroupCopyFromChannel, '/')[last()]"/><xsl:variable name="channelsetting" select="(//osdd:Setting[@id=$currentParameter and ancestor::*[@id=$channel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]"/><xsl:variable name="constantcount" select="count(//osdd:ParameterConstant[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="currentTypeNormalChannel" select="$channelsetting/@Type"/><xsl:variable name="currentTypeDataSelectionChannel" select="$channelsetting/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplateChannel" select="string($channelsetting/@Template)"/><xsl:variable name="currentTypeTemplateChannel" select="(//*[@id=$currentTemplateChannel and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentTypeNormal" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="currentTypeDataSelection" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplate" select="(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Template"/><xsl:variable name="currentTypeTemplate" select="(//*[@id=$currentTemplate and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:variable name="count_setting_param" select="count(//osdd:Setting[@id=$currentParameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_setting_channel" select="count(//osdd:Setting[@id=$currentParameter and ancestor::*[@id=$channel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="not(count(./../*) = 1)    or    compare(string($currentTypeNormalVal),string($currentTypeNormal)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeNormalVal),string($currentTypeDataSelection)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeNormalVal),string($currentTypeTemplate)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0     or    compare(string($currentTypeNormalVal),string($currentTypeNormalChannel)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_channel = 1    or    compare(string($currentTypeNormalVal),string($currentTypeDataSelectionChannel)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_channel = 1    or    compare(string($currentTypeNormalVal),string($currentTypeTemplateChannel)) = 0 and string($currentTypeNormalVal) != ''    and $count_setting_channel = 1     or    compare(string($currentTypeDataSelectionVal),string($currentTypeNormal)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeDataSelectionVal),string($currentTypeDataSelection)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeDataSelectionVal),string($currentTypeTemplate)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0     or    compare(string($currentTypeDataSelectionVal),string($currentTypeNormalChannel)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_channel = 1    or    compare(string($currentTypeDataSelectionVal),string($currentTypeDataSelectionChannel)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_channel = 1    or    compare(string($currentTypeDataSelectionVal),string($currentTypeTemplateChannel)) = 0  and string($currentTypeDataSelectionVal)!= ''    and $count_setting_channel = 1     or    compare(string($currentTypeTemplateVal),string($currentTypeNormal)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeTemplateVal),string($currentTypeDataSelection)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeTemplateVal),string($currentTypeTemplate)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_param &gt;= 1    and $count_setting_channel = 0    or    compare(string($currentTypeTemplateVal),string($currentTypeNormalChannel)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_channel = 1    or    compare(string($currentTypeTemplateVal),string($currentTypeDataSelectionChannel)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_channel = 1    or    compare(string($currentTypeTemplateVal),string($currentTypeTemplateChannel)) = 0 and string($currentTypeTemplateVal) != ''    and $count_setting_channel = 1    or    $constantcount = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(count(./../*) = 1) or compare(string($currentTypeNormalVal),string($currentTypeNormal)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeNormalVal),string($currentTypeDataSelection)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeNormalVal),string($currentTypeTemplate)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeNormalVal),string($currentTypeNormalChannel)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_channel = 1 or compare(string($currentTypeNormalVal),string($currentTypeDataSelectionChannel)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_channel = 1 or compare(string($currentTypeNormalVal),string($currentTypeTemplateChannel)) = 0 and string($currentTypeNormalVal) != '' and $count_setting_channel = 1 or compare(string($currentTypeDataSelectionVal),string($currentTypeNormal)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeDataSelectionVal),string($currentTypeDataSelection)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeDataSelectionVal),string($currentTypeTemplate)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeDataSelectionVal),string($currentTypeNormalChannel)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_channel = 1 or compare(string($currentTypeDataSelectionVal),string($currentTypeDataSelectionChannel)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_channel = 1 or compare(string($currentTypeDataSelectionVal),string($currentTypeTemplateChannel)) = 0 and string($currentTypeDataSelectionVal)!= '' and $count_setting_channel = 1 or compare(string($currentTypeTemplateVal),string($currentTypeNormal)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeTemplateVal),string($currentTypeDataSelection)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeTemplateVal),string($currentTypeTemplate)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_param &gt;= 1 and $count_setting_channel = 0 or compare(string($currentTypeTemplateVal),string($currentTypeNormalChannel)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_channel = 1 or compare(string($currentTypeTemplateVal),string($currentTypeDataSelectionChannel)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_channel = 1 or compare(string($currentTypeTemplateVal),string($currentTypeTemplateChannel)) = 0 and string($currentTypeTemplateVal) != '' and $count_setting_channel = 1 or $constantcount = 1"><xsl:attribute name="role">warning</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.single.parameter.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The standalone 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' does not fit the parent 'Setting' or sibling 'Parameter' data type.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.single.parameter.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der Standalone 'Parameter' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element Datentyp stimmt nicht mit dem übergeordneten 'Setting' oder mit dem Vergleichsparameter Datentyp überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:DataSelection" mode="M46" priority="1003"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' has to be an OSDD data type ('Void' ist not allowed).</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'Type' : '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' muss ein OSDD Datentyp sein ('Void' ist nicht erlaubt).</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@Default)!='' and @Default castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@Default)!='' and @Default castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.default.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'Default' : '<xsl:text/><xsl:value-of select="@Default"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.default.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'Default' : '<xsl:text/><xsl:value-of select="@Default"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="number(@Default) &gt;= number(@RangeMin) and number(@Default) &lt;= number(@RangeMax)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="number(@Default) &gt;= number(@RangeMin) and number(@Default) &lt;= number(@RangeMax)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.check.default.range.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'Default' has invalid content: <xsl:text/><xsl:value-of select="@Default"/><xsl:text/>.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.check.default.range.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'Default' hat einen ungültigen Wert: <xsl:text/><xsl:value-of select="@Default"/><xsl:text/>.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@RangeMin)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@RangeMin)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemin.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemin.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="number(@RangeMin) &lt; number(@RangeMax)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="number(@RangeMin) &lt; number(@RangeMax)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemin.rangemax.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' has to be smaller than the 'DataSelection' attribute 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemin.rangemax.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'RangeMin' : '<xsl:text/><xsl:value-of select="@RangeMin"/><xsl:text/>' muss kleiner sein als das 'DataSelection' Attribut 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@RangeMax)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@RangeMax)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemax.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangemax.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'RangeMax' : '<xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@RangeStep) or normalize-space(@RangeStep)!='' and normalize-space(@RangeStep) != '0'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@RangeStep) or normalize-space(@RangeStep)!='' and normalize-space(@RangeStep) != '0'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangestep.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'RangeStep' : '<xsl:text/><xsl:value-of select="@RangeStep"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.dataselection.rangestep.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'RangeStep' : '<xsl:text/><xsl:value-of select="@RangeStep"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@RangeStep)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@RangeStep)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.dataselection.rangestep.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The DataSelection / RangeStep element uses default value : '1'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.dataselection.rangestep.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das DataSelection / RangeStep Attribut benutzt die Standardeinstellung : '1'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(@RangeStep) or (number(@RangeMax) - number(@RangeMin)) mod number(@RangeStep) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@RangeStep) or (number(@RangeMax) - number(@RangeMin)) mod number(@RangeStep) = 0"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.dataselection.check.range.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' range can not be reached with given 'RangeStep'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.dataselection.check.range.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'DataSelection' Range kann mit dem gegebenen 'RangeStep' nicht erreicht werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@RangeStep) or (number(@Default) - number(@RangeMin)) mod number(@RangeStep) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@RangeStep) or (number(@Default) - number(@RangeMin)) mod number(@RangeStep) = 0"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.dataselection.check.default.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Default' value can not be reached with given 'RangeStep'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.dataselection.check.default.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'Default' Wert kann mit dem gegebenen 'RangeStep' nicht erreicht werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Template) or normalize-space(@Template)!='' and @Template castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Template) or normalize-space(@Template)!='' and @Template castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' attribute 'Template' : '<xsl:text/><xsl:value-of select="@Template"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Attribut 'Template' : '<xsl:text/><xsl:value-of select="@Template"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="template_range" select="string(./@Template)"/><xsl:variable name="count_choice" select="count(//osdd:Choice[@id=$template_range and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="count_range" select="count(//osdd:Range[@id=$template_range and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="not(@Template) or $count_choice = 1 or $count_range = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Template) or $count_choice = 1 or $count_range = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' element with 'Template' : <xsl:text/><xsl:value-of select="@Template"/><xsl:text/>' has to exist in 'SettingDataTemplates'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataSelection' Element mit 'Template' : <xsl:text/><xsl:value-of select="@Template"/><xsl:text/>' muss in den 'SettingDataTemplates' Elementen existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Template) or not(@RangeMax or @RangeMin or @UnitScale or @Type)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Template) or not(@RangeMax or @RangeMin or @UnitScale or @Type)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.dependencies.en"><xsl:attribute name="xml:lang">en</xsl:attribute>If 'DataSelection' element with 'Template' : <xsl:text/><xsl:value-of select="@Template"/><xsl:text/> exist then 'RangeMax', 'RangeMin', 'UnitScale', 'Default' and 'Type' must not exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.dataselection.template.dependencies.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Wenn 'DataSelection' Element mit 'Template' : <xsl:text/><xsl:value-of select="@Template"/><xsl:text/> existiert dann dürfen 'RangeMax', 'RangeMin', 'UnitScale', 'Default' und 'Type' nicht existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(@UnitScale)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@UnitScale)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.dataselection.unit.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The RangeDefinition / UnitScale element has default value : <xsl:text/><xsl:value-of select="@StepSize"/><xsl:text/>.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.dataselection.unit.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das RangeDefinition / UnitScale Attribut hat die Standardeinstellung : <xsl:text/><xsl:value-of select="@StepSize"/><xsl:text/>.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions" mode="M46" priority="1002"><xsl:choose><xsl:when test="count(./*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Conditions' element must not be empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Conditions' Element darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Group" mode="M46" priority="1001"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.itemcount.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.itemcount.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="group_name" select="string(@Name)"/><xsl:choose><xsl:when test="not(@Name) or count(//osdd:Group[@Name=$group_name and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or count(//osdd:Group[@Name=$group_name and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' : '<xsl:text/><xsl:value-of select="$group_name"/><xsl:text/>' has to be unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'Group' : '<xsl:text/><xsl:value-of select="$group_name"/><xsl:text/>' muss einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or ../osdd:Conditions"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or ../osdd:Conditions"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.standalone.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Group' is designed as standalone one but has no 'Name' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.standalone.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine 'Group' ist als Standalone definiert aber enthält kein 'Name' Attribut.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Item" mode="M46" priority="1000"><xsl:choose><xsl:when test="normalize-space(.) != '' and . castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(.) != '' and . castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.item.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Item' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' element must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.group.item.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Item' : '<xsl:text/><xsl:value-of select="."/><xsl:text/>' Element muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="text()" mode="M46" priority="-1"/><xsl:template match="@*|node()" mode="M46" priority="-2"><xsl:apply-templates mode="M46" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation" mode="M47" priority="1015"><xsl:choose><xsl:when test="normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Validation' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Validation' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentName" select="@Name"/><xsl:choose><xsl:when test="count(./../osdd:Validation[@Name=$currentName]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./../osdd:Validation[@Name=$currentName]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Validation' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' must be  unique within the 'Setting'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Validation' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' Element muss innerhalb des 'Settings' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:And" mode="M47" priority="1014"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.and.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' element must have sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.and.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' Element muss Subelemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.comparison.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The comparison element must include sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.comparison.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Vergleichselement darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies    count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1    or    count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:And/osdd:In/osdd:Parameter" mode="M47" priority="1013"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:And/osdd:In/osdd:Group" mode="M47" priority="1012"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item) = 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item) = 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Validation/osdd:And/osdd:Not" mode="M47" priority="1011"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Not' element within an 'And' or 'Or' element must not include more than one comparison construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'Not' Element in einem 'And' or 'Or' Element darf nicht mehr als ein Vergleichskonstrukt enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.childs.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' / 'Not' or 'Or' / 'Not' comparison element must not be empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.childs.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' / 'Not' oder 'Or' / 'Not' Vergleichskonstrukt darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 or count(./ancestor::osdd:ChannelSettings/osdd:Setting[@id=$para]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 or count(./ancestor::osdd:ChannelSettings/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:And/osdd:Not/osdd:In/osdd:Parameter" mode="M47" priority="1010"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:And/osdd:Not/osdd:In/osdd:Group" mode="M47" priority="1009"><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Validation/osdd:Or" mode="M47" priority="1008"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.or.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Or' element must have sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.or.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Or' Element muss Subelemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.comparison.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The comparison element must include sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.comparison.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Vergleichselement darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies    count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1    or    count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1    and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 or count(./ancestor::osdd:ChannelSettings/osdd:Setting[@id=$para]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 or count(./ancestor::osdd:ChannelSettings/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:Or/osdd:In/osdd:Parameter" mode="M47" priority="1007"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:Or/osdd:In/osdd:Group" mode="M47" priority="1006"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Validation/osdd:Or/osdd:Not" mode="M47" priority="1005"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Not' element within an 'And' or 'Or' element must not include more than one comparison construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'Not' Element in einem 'And' or 'Or' Element darf nicht mehr als ein Vergleichskonstrukt enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies $sub/name() = 'IsUsed' or count($sub/child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.childs.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' / 'Not' or 'Or' / 'Not' comparison element must not be empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.element.childs.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' / 'Not' oder 'Or' / 'Not' Vergleichskonstrukt darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:Or/osdd:Not/osdd:In/osdd:Parameter" mode="M47" priority="1004"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Validation/osdd:Or/osdd:Not/osdd:In/osdd:Group" mode="M47" priority="1003"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.not.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Validation/osdd:Action" mode="M47" priority="1002"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.action.en"><xsl:attribute name="xml:lang">en</xsl:attribute>There is only one 'Action' child-element allowed per comparison element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.action.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Es ist nur ein 'Action' Kindelement pro Vergleichskonstrukt erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:ForceValue) or normalize-space(./osdd:ForceValue) != '' and ./osdd:ForceValue castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ForceValue) or normalize-space(./osdd:ForceValue) != '' and ./osdd:ForceValue castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.forcevalue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ForceValue' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.forcevalue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ForceValue' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSetting" select="ancestor::osdd:Setting/@id"/><xsl:variable name="currentTypeNormal" select="ancestor::osdd:Setting/@Type"/><xsl:variable name="currentTypeDataSelection" select="ancestor::osdd:Setting/osdd:DataSelection/@Type"/><xsl:variable name="currentTemplate" select="ancestor::osdd:Setting/@Template"/><xsl:variable name="currentTypeTemplate" select="(//*[@Name=$currentTemplate and @Type and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])[1]/@Type"/><xsl:choose><xsl:when test="not(./osdd:ForceValue)   or myFunction:typeCheck($currentTypeNormal,./osdd:ForceValue) = 1   or myFunction:typeCheck($currentTypeDataSelection,./osdd:ForceValue) = 1   or myFunction:typeCheck($currentTypeTemplate,./osdd:ForceValue) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ForceValue) or myFunction:typeCheck($currentTypeNormal,./osdd:ForceValue) = 1 or myFunction:typeCheck($currentTypeDataSelection,./osdd:ForceValue) = 1 or myFunction:typeCheck($currentTypeTemplate,./osdd:ForceValue) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.forcevalue.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ForceValue' element : '<xsl:text/><xsl:value-of select="./osdd:ForceValue"/><xsl:text/>' has to match the parent 'Setting' data type : '<xsl:text/><xsl:value-of select="$currentTypeNormal"/><xsl:text/><xsl:text/><xsl:value-of select="$currentTypeDataSelection"/><xsl:text/><xsl:text/><xsl:value-of select="$currentTypeTemplate"/><xsl:text/>'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.forcevalue.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ForceValue' Element : '<xsl:text/><xsl:value-of select="./osdd:ForceValue"/><xsl:text/>' muss dem Parent 'Setting' Datentyp : '<xsl:text/><xsl:value-of select="$currentTypeNormal"/><xsl:text/><xsl:text/><xsl:value-of select="$currentTypeDataSelection"/><xsl:text/><xsl:text/><xsl:value-of select="$currentTypeTemplate"/><xsl:text/>' entsprechen.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:IsUsed" mode="M47" priority="1001"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="(.[not(text()) and not(@ChannelGroup)] and ancestor::osdd:ChannelSettings) or .[text() and @ChannelGroup] "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="(.[not(text()) and not(@ChannelGroup)] and ancestor::osdd:ChannelSettings) or .[text() and @ChannelGroup]"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'IsUsed' element has to be either empty within 'ChannelSettings' or has to have a 'ChannelGroup' and a 'Channel' defined.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'IsUsed' muss entweder den ParentChannel referenzieren oder einen 'Channel' in einer anderen 'ChannelGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@ChannelGroup) or normalize-space(@ChannelGroup) != '' and @ChannelGroup castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@ChannelGroup) or normalize-space(@ChannelGroup) != '' and @ChannelGroup castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.channelgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'IsUsed' attribute 'ChannelGroup' must not be empty and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.channelgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'IsUsed' Attribut 'ChannelGroup' darf nicht leer sein und muss Datentyp xs:string haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="group" select="@ChannelGroup"/><xsl:variable name="channel" select="."/><xsl:choose><xsl:when test="not(@ChannelGroup)    or count(//osdd:Channel[@id=$channel and ancestor::osdd:ChannelGroup[@id=$group] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@ChannelGroup) or count(//osdd:Channel[@id=$channel and ancestor::osdd:ChannelGroup[@id=$group] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.reference.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'IsUsed' element references a  Channel within a ChannelGroup which does not exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.isused.reference.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'IsUsed' Element referenziert einen Channel in einer ChannelGroup der nicht existiert.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:With" mode="M47" priority="1000"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="settingsgroup" select="tokenize(@ifParameter, '/')[position() = 1]"/><xsl:variable name="parameter" select="tokenize(@ifParameter, '/')[last()]"/><xsl:variable name="countSettingsGroup" select="count(//osdd:SettingsGroup[@id=$settingsgroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="countSetting" select="count(//osdd:Setting[@id=$parameter and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="$countSettingsGroup = 1 and $countSetting &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$countSettingsGroup = 1 and $countSetting &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.with.ifparameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ifParameter' : '<xsl:text/><xsl:value-of select="@ifParameter"/><xsl:text/>' attribute in the 'With' element references a Parameter/Setting which does not exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.with.ifparameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ifParameter' : '<xsl:text/><xsl:value-of select="@ifParameter"/><xsl:text/>' Attribut in dem 'With' Element referenziert einen nicht existierenden Parameter/Setting.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="text()" mode="M47" priority="-1"/><xsl:template match="@*|node()" mode="M47" priority="-2"><xsl:apply-templates mode="M47" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility" mode="M48" priority="1013"><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:And" mode="M48" priority="1012"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.and.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' element must have sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.and.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' Element muss Subelemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.comparison.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The comparison element must include sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.comparison.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Vergleichselement darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:And/osdd:In/osdd:Parameter" mode="M48" priority="1011"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:And/osdd:In/osdd:Group" mode="M48" priority="1010"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!='' and @Ref castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Visibility/osdd:And/osdd:Not" mode="M48" priority="1009"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Not' element within an 'And' or 'Or' element must not include more than one comparison construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'Not' Element in einem 'And' or 'Or' Element darf nicht mehr als ein Vergleichskonstrukt enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.childs.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' / 'Not' or 'Or' / 'Not' comparison element must not be empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.childs.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' / 'Not' oder 'Or' / 'Not' Vergleichskonstrukt darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:And/osdd:Not/osdd:In/osdd:Parameter" mode="M48" priority="1008"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:And/osdd:Not/osdd:In/osdd:Group" mode="M48" priority="1007"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Visibility/osdd:Or" mode="M48" priority="1006"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.or.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Or' element must have sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.or.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Or' Element muss Subelemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.comparison.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The comparison element must include sub-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.comparison.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Vergleichselement darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:Or/osdd:In/osdd:Parameter" mode="M48" priority="1005"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:Or/osdd:In/osdd:Group" mode="M48" priority="1004"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.validation.in.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Visibility/osdd:Or/osdd:Not" mode="M48" priority="1003"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A 'Not' element within an 'And' or 'Or' element must not include more than one comparison construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'Not' Element in einem 'And' or 'Or' Element darf nicht mehr als ein Vergleichskonstrukt enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $sub in ./* satisfies count($sub/child::*) &gt; 0 or $sub/name() = 'IsUsed'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.childs.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'And' / 'Not' or 'Or' / 'Not' comparison element must not be empty.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.element.childs.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'And' / 'Not' oder 'Or' / 'Not' Vergleichskonstrukt darf nicht leer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $parameter in ./*/osdd:Parameter satisfies normalize-space($parameter)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $par in ./*/osdd:Parameter[@SettingsGroup] satisfies normalize-space($par/@SettingsGroup)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.settingsgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' attribute 'SettingsGroup' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.settingsgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Attribut 'SettingsGroup' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $value in ./*/osdd:Value satisfies normalize-space($value)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Value' element must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Value' Element muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $group in ./*/osdd:Parameter[@SettingsGroup] satisfies count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Setting[@id=$group]) = 1 or count(//osdd:SettingsGroup[@id=$group/@SettingsGroup and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 and count(//osdd:ChannelSettings/osdd:Setting[@id=$group and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.and.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'SettingsGroup' does not exist or the 'Setting' does not exist within the referenced 'SettingsGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.and.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Eine referenzierte 'SettingsGroup' existiert nicht oder ein 'Setting' existiert nicht in der referenzierten 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1 "/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $para in ./*/osdd:Parameter[not(@*)] satisfies count(./ancestor::osdd:SettingsGroup/osdd:Setting[@id=$para]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.reference.group.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A referenced 'Setting' does not exist within the same 'SettingGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.setting.reference.group.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein referenziertes 'Setting' existiert nicht in der selben 'SettingsGroup'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $combi in ./*/osdd:Parameter satisfies count($combi/following-sibling::osdd:Parameter) &gt;= 0 and count($combi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $valuecombi in ./*/osdd:Value satisfies count($valuecombi/following-sibling::osdd:Value) = 0 and count($valuecombi/following-sibling::osdd:Parameter) &gt;= 0 and count($valuecombi/following-sibling::osdd:Parameter) &lt; 2"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' / 'Value' combination is not allowed within the logical construct.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.parameter.value.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die Kombination aus 'Parameter' und 'Value' ist ungültig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:Or/osdd:Not/osdd:In/osdd:Parameter" mode="M48" priority="1002"><xsl:choose><xsl:when test="not(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Parameter' Element is not allowed within an 'In' Element. Use the 'Equal' element for 'Parameters'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.in.parameter.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Parameter' Element darf nicht innerhalb eines 'In' Elements verwendet werden. Hierfür muss das 'Equal' Element benutzt werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Setting/osdd:Conditions/osdd:Visibility/osdd:Or/osdd:Not/osdd:In/osdd:Group" mode="M48" priority="1001"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or normalize-space(@Ref)!=''"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or normalize-space(@Ref)!=''"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.ref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must have a valid value.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.ref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss einen gültigen Wert haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name and @Ref)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name and @Ref)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' attribute 'Ref' and the 'Group' attribute 'Name' can not both exist in the same 'Group'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Attribut 'Ref' und das 'Group' Attribut 'Name' dürfen nicht im gleichen 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="@Name or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@Name or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Either 'Group' attribute 'Ref' or the 'Group' attribute 'Name' has to exist within a 'Group' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.nameref.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Entweder das 'Group' Attribut 'Ref' oder das 'Group' Attribut 'Name' müssen in einem 'Group' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Item) &gt; 0 or @Ref"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Item) &gt; 0 or @Ref"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.itemcount.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Group' element has to include 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.itemcount.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Group' Element muss 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Ref) or count(./osdd:Item)=0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(./osdd:Item)=0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refitem.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' must not have 'Item' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refitem.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' darf keine 'Item' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="ref" select="string(@Ref)"/><xsl:choose><xsl:when test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Ref) or count(//osdd:Group[@Name=$ref and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refexist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The referenced 'Group' : '<xsl:text/><xsl:value-of select="$ref"/><xsl:text/>' must exist or is not unique.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.not.group.refexist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die referenzierte 'Group' : '<xsl:text/><xsl:value-of select="@Ref"/><xsl:text/>' muss existieren oder ist nicht einzigartig.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="//osdd:Visibility/osdd:Action" mode="M48" priority="1000"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="count(./child::*) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./child::*) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.action.en"><xsl:attribute name="xml:lang">en</xsl:attribute>There is only one or more 'Action' child-elements allowed per comparison element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.action.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Es ist nur ein oder mehrere 'Action' Kindelemente pro Vergleichskonstrukt erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentEnable" select="string(./osdd:Enable)"/><xsl:choose><xsl:when test="not(./osdd:Enable) or normalize-space(./osdd:Enable) = '' or count(//osdd:Setting[@id = $currentEnable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1 or count(//osdd:SettingsGroup[@id = $currentEnable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Enable) or normalize-space(./osdd:Enable) = '' or count(//osdd:Setting[@id = $currentEnable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1 or count(//osdd:SettingsGroup[@id = $currentEnable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.enable.exist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' <xsl:text/><xsl:value-of select="$currentEnable"/><xsl:text/> has to exist to be referenced within an 'Enable' Action.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.enable.exist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' <xsl:text/><xsl:value-of select="$currentEnable"/><xsl:text/> muss existieren damit es in einer 'Enable' Action referenziert werden kann.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentDisable" select="string(./osdd:Disable)"/><xsl:choose><xsl:when test="not(./osdd:Disable) or normalize-space(./osdd:Disable) = '' or count(//osdd:Setting[@id = $currentDisable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1 or count(//osdd:SettingsGroup[@id = $currentDisable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Disable) or normalize-space(./osdd:Disable) = '' or count(//osdd:Setting[@id = $currentDisable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1 or count(//osdd:SettingsGroup[@id = $currentDisable and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.disable.exist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Setting' <xsl:text/><xsl:value-of select="$currentDisable"/><xsl:text/> has to exist to be referenced within an 'Disable' Action.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.setting.conditions.visibility.disable.exist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Setting' <xsl:text/><xsl:value-of select="$currentDisable"/><xsl:text/> muss existieren damit es in einer 'Disable' Action referenziert werden kann.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="text()" mode="M48" priority="-1"/><xsl:template match="@*|node()" mode="M48" priority="-2"><xsl:apply-templates mode="M48" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration" mode="M49" priority="1011"><xsl:choose><xsl:when test="count(./osdd:ChannelGroup) &gt;= 1 or count(./osdd:DataTransport) &gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:ChannelGroup) &gt;= 1 or count(./osdd:DataTransport) &gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.en"><xsl:attribute name="xml:lang">en</xsl:attribute>There has to exist at least one 'ChannelGroup'  or 'DataTransport' element within a 'ChannelConfiguration' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.de"><xsl:attribute name="xml:lang">de</xsl:attribute>In einer 'ChannelConfiguration' muss zumindest ein 'ChannelGroup' oder ein 'DataTransport' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:DataTransport" mode="M49" priority="1010"><xsl:choose><xsl:when test="count(./osdd:SPDOTransport[@Direction='Input']) &gt;= 0 and count(./osdd:SPDOTransport[@Direction='Output']) &gt;= 0 and count(./osdd:SPDOTransport)&gt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:SPDOTransport[@Direction='Input']) &gt;= 0 and count(./osdd:SPDOTransport[@Direction='Output']) &gt;= 0 and count(./osdd:SPDOTransport)&gt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.en"><xsl:attribute name="xml:lang">en</xsl:attribute>There has to exist at least one 'Input' 'SPDOTransport' element or one 'Output' 'SPDOTransport' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Es müssen zumindest ein 'Input' 'SPDOTransport' Element oder ein 'Output' 'SPDOTransport' Element existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:DataTransport/osdd:SPDOTransport" mode="M49" priority="1009"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name)!='' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SPDOTransport' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentName" select="string(@Name)"/><xsl:choose><xsl:when test="count(//osdd:SPDOTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:SPDOTransport[@Name=$currentName and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.name.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' element has to be unique within the 'Module'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.name.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentName"/><xsl:text/>' Element muss im 'Module' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(@Direction,'^(Input|Output)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(@Direction,'^(Input|Output)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.direction.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' attribute 'Direction' : '<xsl:text/><xsl:value-of select="@Direction"/><xsl:text/> has to be either 'Input' or 'Output'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.direction.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SPDOTransport' Attribut 'Direction' : '<xsl:text/><xsl:value-of select="@Direction"/><xsl:text/>' muss entweder 'Input' oder 'Output' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="string(@OctetSize) castable as xs:integer and @OctetSize &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@OctetSize) castable as xs:integer and @OctetSize &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' attribute 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' has to be a positive Integer.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SPDOTransport' Attribut 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' muss ein positiver Integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSize" select="number(@OctetSize)"/><xsl:choose><xsl:when test="$currentSize mod 2 &gt; 0 and ($currentSize &gt;= 11 and $currentSize &lt;= 27 or $currentSize &gt;= 31 and $currentSize &lt;= 521)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$currentSize mod 2 &gt; 0 and ($currentSize &gt;= 11 and $currentSize &lt;= 27 or $currentSize &gt;= 31 and $currentSize &lt;= 521)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.frame.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' with 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' does not fit in an openSAFETY frame.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.frame.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'SPDOTransport' mit 'OctetSize' : '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' hat die falsche Größe für einen openSAFETY Frame.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="channel" select="string(@Name)"/><xsl:variable name="count_boolean" select="count(distinct-values(//osdd:DataValue[@Type = 'Boolean' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel and @Index]))"/><xsl:variable name="count_int8" select="count(//osdd:DataValue[@Type = 'Int8' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int16" select="count(//osdd:DataValue[@Type = 'Int16' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int24" select="count(//osdd:DataValue[@Type = 'Int24' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int32" select="count(//osdd:DataValue[@Type = 'Int32' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int40" select="count(//osdd:DataValue[@Type = 'Int40' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int48" select="count(//osdd:DataValue[@Type = 'Int48' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int56" select="count(//osdd:DataValue[@Type = 'Int56' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_int64" select="count(//osdd:DataValue[@Type = 'Int64' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint8" select="count(//osdd:DataValue[@Type = 'UInt8' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint16" select="count(//osdd:DataValue[@Type = 'UInt16' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint24" select="count(//osdd:DataValue[@Type = 'UInt24' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint32" select="count(//osdd:DataValue[@Type = 'UInt32' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint40" select="count(//osdd:DataValue[@Type = 'UInt40' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint48" select="count(//osdd:DataValue[@Type = 'UInt48' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint56" select="count(//osdd:DataValue[@Type = 'UInt56' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Uint64" select="count(//osdd:DataValue[@Type = 'UInt64' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Float32" select="count(//osdd:DataValue[@Type = 'Float32' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="count_Float64" select="count(//osdd:DataValue[@Type = 'Float64' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]/osdd:Transport[@Name=$channel])"/><xsl:variable name="domain_nodeset" select="//osdd:DataValue[@Type='Domain' and @NrOfOctets and descendant::osdd:Transport[@Name=$channel] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="count_domain"><xsl:value-of select="sum(exslt:node-set($domain_nodeset)/@NrOfOctets)"/></xsl:variable><xsl:variable name="byte_count" select="$count_boolean + $count_int8 + $count_int16 * 2 + $count_int24 * 3 + $count_int32 * 4 + $count_int40 * 5 + $count_int48 * 6 + $count_int56 * 7 + $count_int64 * 8 + $count_Uint8 + $count_Uint16 * 2 + $count_Uint24 * 3 + $count_Uint32 * 4 + $count_Uint40 * 5 + $count_Uint48 * 6 + $count_Uint56 * 7 + $count_Uint64 * 8 + $count_Float32 * 4 + $count_Float64 * 8 + $count_domain"/><xsl:variable name="count_complete" select="myFunction:SPDOoctetSize($byte_count)"/><xsl:choose><xsl:when test="number($count_complete) &lt;= number(@OctetSize)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="number($count_complete) &lt;= number(@OctetSize)"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$channel"/><xsl:text/>' requires at least '<xsl:text/><xsl:value-of select="$count_complete"/><xsl:text/>' octets for SPDO but has only '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' octets defined. Depending in the different 'Channels' it may need more octets. Please refer to the 'Channel' error messages.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.octetsize.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$channel"/><xsl:text/>' braucht im besten Fall '<xsl:text/><xsl:value-of select="$count_complete"/><xsl:text/>' SPDO Oktets aber hat nur '<xsl:text/><xsl:value-of select="@OctetSize"/><xsl:text/>' Oktets definiert. Die Zahl der benötigten Oktets kann sich durch die Channel Konfiguration noch erhöhen. Bitte die entsprechenden Fehlermeldungen beachten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="string(@MaxReactionTime) castable as xs:integer and @MaxReactionTime &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@MaxReactionTime) castable as xs:integer and @MaxReactionTime &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.maxreactiontime.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SPDOTransport' attribute 'MaxReactionTime' : '<xsl:text/><xsl:value-of select="@MaxReactionTime"/><xsl:text/> has to be a positive Integer'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.spdotransport.maxreactiontime.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SPDOTransport' Attribut 'MaxReactionTime' : '<xsl:text/><xsl:value-of select="@MaxReactionTime"/><xsl:text/>' muss ein positiver Integer sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup" mode="M49" priority="1008"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:choose><xsl:when test="not(@id) or normalize-space(@id)!='' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@id) or normalize-space(@id)!='' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ChannelGroup' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ChannelGroup' Attribut 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ChannelGroup' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ChannelGroup' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:Channel) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:Channel) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.count.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ChannelGroup' : '<xsl:text/><xsl:value-of select="string(@id)"/><xsl:text/>' must have child-elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channelgroup.count.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'ChannelGroup' : '<xsl:text/><xsl:value-of select="string(@id)"/><xsl:text/>' muss Kindelemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(//osdd:ConnectionValidation[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(//osdd:ConnectionValidation[ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.connectionvalidation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>There exists none or more than one 'ConnectionValidation' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.connectionvalidation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Es existieren kein oder mehrere 'ConnectionValidation' Element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='true']" mode="M49" priority="1007"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="groupID" select="string(../@id)"/><xsl:variable name="channelID" select="string(./@id)"/><xsl:variable name="name" select="string-join(($groupID,$channelID),'/')"/><xsl:choose><xsl:when test="not(./osdd:ChannelSettings) or count(//osdd:SettingsGroup[@CopyFromChannel=$name and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ChannelSettings) or count(//osdd:SettingsGroup[@CopyFromChannel=$name and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.copyfromchannel.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' : <xsl:text/><xsl:value-of select="$name"/><xsl:text/> does not have a corresponding 'CopyFromChannel' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.copyfromchannel.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'SafeChannel' : <xsl:text/><xsl:value-of select="$name"/><xsl:text/> hat kein dazugehöriges'CopyFromChannel' Element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@id) != '' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id) != '' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' Attribut 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentChannel" select="@id"/><xsl:choose><xsl:when test="count(./../osdd:Channel[@id=$currentChannel]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./../osdd:Channel[@id=$currentChannel]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must be unique inside the 'ChannelGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' oder 'Channel' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' Element muss innerhalb der 'ChannelGroup' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="count(./osdd:DataValue) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./osdd:DataValue) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataValue'element has to exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataValue' Element muss existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(./osdd:DataValue/@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(./osdd:DataValue/@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataValue' attribute 'Type' has to be an OpenSafety datatype except the 'Void' datatype.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataValue' Attribut 'Type' muss ein OpenSafety Datentyp sein und darf nicht 'void' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@displayWithProfile) or @displayWithProfile and count(./osdd:ProfileInfo) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayWithProfile) or @displayWithProfile and count(./osdd:ProfileInfo) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.displayWithProfile.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Channel: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> must not have a 'displayWithProfile' attribute because it does not belong to a Profile.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.displayWithProfile.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der Kanal: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> darf kein 'displayWithProfile' Attribut besitzen weil er keinem Profil angehört.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $profile in ./osdd:ProfileInfo satisfies (normalize-space($profile)='' and count($profile/osdd:ProfileRepetition) = 1) or (normalize-space($profile)!='' and count($profile/osdd:ProfileRepetition) = 0)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $profile in ./osdd:ProfileInfo satisfies (normalize-space($profile)='' and count($profile/osdd:ProfileRepetition) = 1) or (normalize-space($profile)!='' and count($profile/osdd:ProfileRepetition) = 0)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.ProfileInfo.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The ProfileInfo within the Channel:<xsl:text/><xsl:value-of select="@id"/><xsl:text/> can either have a text value or a ChannelRepetition element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.ProfileInfo.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das ProfileInfo Element im Kanal:<xsl:text/><xsl:value-of select="@id"/><xsl:text/> kann entweder einen Textinhalt oder ein ProfileRepetition Element enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="every $profile in ./osdd:ProfileInfo/@profile satisfies (normalize-space($profile)!='' and count(//osdd:Profile[text()=$profile and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="every $profile in ./osdd:ProfileInfo/@profile satisfies (normalize-space($profile)!='' and count(//osdd:Profile[text()=$profile and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.ProfileInfo.profile.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The ProfileInfo within the Channel:'<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' references profile:'<xsl:text/><xsl:value-of select="./osdd:ProfileInfo/@profile"/><xsl:text/>' which is not present in DeviceInformation/Profiles section.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.ProfileInfo.profile.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das ProfileInfo Element im Kanal:'<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' referenziert das Profil:'<xsl:text/><xsl:value-of select="./osdd:ProfileInfo/@profile"/><xsl:text/>' welches im DeviceInformation/Profiles Abschnitt nicht definiert wird.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='true']/osdd:DataValue" mode="M49" priority="1006"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="isSafeMotionModule" select="count(//osdd:Profile[text()='SafeMotion' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="isSafeVisionModule" select="count(//osdd:Profile[text()='Vision' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="($isSafeMotionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')) or ($isSafeVisionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')) or not(./osdd:SODPosition) or matches(./osdd:SODPosition/@Index,'^(0x6[0-3]{1}[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($isSafeMotionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')) or ($isSafeVisionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')) or not(./osdd:SODPosition) or matches(./osdd:SODPosition/@Index,'^(0x6[0-3]{1}[0-9a-fA-F]{2})$')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.sodposition.format.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@Index)"/><xsl:text/>' defines a profile object but there is no profile defined for the module.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.sodposition.format.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribut 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@Index)"/><xsl:text/>' definiert ein Profilobjekt aber es ist kein Profil für das Modul definiert.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:SODPosition) or matches(./osdd:SODPosition/@SubIndex,'^(0x[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:SODPosition) or matches(./osdd:SODPosition/@SubIndex,'^(0x[0-9a-fA-F]{2})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.format.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'SubIndex' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@SubIndex)"/><xsl:text/>' does not match the specified range.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.format.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribut 'SubIndex' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@SubIndex)"/><xsl:text/>' stimmt nicht mit dem spezifizierten Format überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentIndex" select="./osdd:SODPosition/@Index"/><xsl:variable name="currentSubIndex" select="./osdd:SODPosition/@SubIndex"/><xsl:choose><xsl:when test="not(./osdd:SODPosition)     or      ((count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 8     and      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1)     and      not(      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0     and      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:SODPosition) or ((count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 8 and count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1) and not( count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 and count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' element with 'Index' : '<xsl:text/><xsl:value-of select="$currentIndex"/><xsl:text/>' and 'SubIndex' : <xsl:text/><xsl:value-of select="$currentSubIndex"/><xsl:text/> has to be unique within the 'Module'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Element mit 'Index' : '<xsl:text/><xsl:value-of select="$currentIndex"/><xsl:text/>' und 'SubIndex' : <xsl:text/><xsl:value-of select="$currentSubIndex"/><xsl:text/> muss im 'Module' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation) or (./osdd:Transport or ./osdd:ConnectionValidation)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation) or (./osdd:Transport or ./osdd:ConnectionValidation)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' element must exist within a 'ChannelConfiguration' if no 'ConnectionValidation' element exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Element muss in einer 'ChannelConfiguration' existieren wenn kein 'ConnectionValidation' Element existiert.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentspdo" select="string(./osdd:Transport/@Name)"/><xsl:choose><xsl:when test="not(./osdd:Transport/@Name) or count(//osdd:SPDOTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 or count(//osdd:DataTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:ACyclicTransport]) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport/@Name) or count(//osdd:SPDOTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 or count(//osdd:DataTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:ACyclicTransport]) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.exist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentspdo"/><xsl:text/>' element could not be referenced to an existing 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.exist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentspdo"/><xsl:text/>' Element kann nicht mit einem 'SPDOTransport' Element referenziert werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:Transport) or matches(./osdd:Transport/@Index,'^(0x[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport) or matches(./osdd:Transport/@Index,'^(0x[0-9a-fA-F]{2})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.index.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@Index)"/><xsl:text/>' does not match the specified range.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.index.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Attribut 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@Index)"/><xsl:text/>' stimmt nicht mit dem spezifizierten Format überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="./osdd:Transport/@Name"/><xsl:variable name="currentSPDOPos" select="myFunction:hex2dec(./osdd:Transport/@Index)"/><xsl:variable name="test" select="./osdd:DataSequence/@RangeMax"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="currentRange"><xsl:choose><xsl:when test="./osdd:DataSequence/@RangeMax"><xsl:value-of select="number(./osdd:DataSequence/@RangeMax - ./osdd:DataSequence/@RangeMin)"/></xsl:when><xsl:otherwise><xsl:value-of select="1"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="currentSPDODataSize" select="myFunction:typeSize(@Type)"/><xsl:variable name="currentComplete" select="ceiling($currentSPDOPos + $currentSPDODataSize * $currentRange)"/><xsl:variable name="currentOctetSize" select="../../../osdd:DataTransport/osdd:SPDOTransport[@Name =$currentSPDO]/@OctetSize"/><xsl:variable name="currentChannel" select="../@id"/><xsl:choose><xsl:when test="not(./osdd:Transport) or ./osdd:ConnectionValidation or $currentOctetSize &gt;= $currentComplete"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport) or ./osdd:ConnectionValidation or $currentOctetSize &gt;= $currentComplete"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Channel' : '<xsl:text/><xsl:value-of select="$currentChannel"/><xsl:text/>' would require the 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' to have at least : '<xsl:text/><xsl:value-of select="$currentComplete"/><xsl:text/>' octets but only has : '<xsl:text/><xsl:value-of select="$currentOctetSize"/><xsl:text/>' octets.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'Channel' : '<xsl:text/><xsl:value-of select="$currentChannel"/><xsl:text/>' benötigt ein 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' mit mindestens : '<xsl:text/><xsl:value-of select="$currentComplete"/><xsl:text/>' Oktets, aber hat nur : '<xsl:text/><xsl:value-of select="$currentOctetSize"/><xsl:text/>' Oktets.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="string(./osdd:Transport/@Name)"/><xsl:variable name="currentSPDOPos" select="./osdd:Transport/@Index"/><xsl:choose><xsl:when test="./osdd:ConnectionValidation or not(./osdd:Transport) or @Type ='Boolean' or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or not(./osdd:Transport) or @Type ='Boolean' or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.count.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' attribute 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' is already used within the 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.count.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' Attribut 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' wird im 'SPDOTransport' bereits benutzt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="string(./osdd:Transport/@Name)"/><xsl:variable name="currentSPDOPos" select="./osdd:Transport/@Index"/><xsl:variable name="currentBitMask" select="./osdd:Transport/@BitMask"/><xsl:choose><xsl:when test="./osdd:ConnectionValidation or not(./osdd:Transport) or not(@Type='Boolean') or  count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and not(@BitMask) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and @BitMask=$currentBitMask and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or not(./osdd:Transport) or not(@Type='Boolean') or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and not(@BitMask) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and @BitMask=$currentBitMask and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.count.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' : 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' attribute 'Bitmask' : '<xsl:text/><xsl:value-of select="$currentBitMask"/><xsl:text/>' does not exist or is already used within the 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.count.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>'  : 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' Attribut 'Bitmask' : '<xsl:text/><xsl:value-of select="$currentBitMask"/><xsl:text/>' wird im 'SPDOTransport' bereits benutzt oder ist nicht vorhanden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./osdd:ConnectionValidation or not(@Type = 'Boolean') and not(./osdd:Transport/@BitMask) or @Type='Boolean'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or not(@Type = 'Boolean') and not(./osdd:Transport/@BitMask) or @Type='Boolean'"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.type.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' attribute 'BitMask' must not exist with other 'DataValue' : 'Type' than 'Boolean'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.type.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Attribut 'BitMask' darf nur bei 'DataValue' : 'Type' : 'Boolean' existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:Transport/@BitMask) or matches(./osdd:Transport/@BitMask,'^(0x01|0x02|0x04|0x08|0x10|0x20|0x40|0x80)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport/@BitMask) or matches(./osdd:Transport/@BitMask,'^(0x01|0x02|0x04|0x08|0x10|0x20|0x40|0x80)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' attribute 'BitMask' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@BitMask)"/><xsl:text/>' does not match the specified range.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Attribut 'BitMask' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@BitMask)"/><xsl:text/>' stimmt nicht mit dem spezifizierten Format überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(./osdd:Transport/@BitMask) and not(./osdd:ConnectionValidation)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport/@BitMask) and not(./osdd:ConnectionValidation)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.bitmask.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Transport attribute BitMask uses default value : '0x01'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.bitmask.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Transport Attribut BitMask benutzt die Standardeinstellung: '0x01'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation and ./osdd:Transport)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation and ./osdd:Transport)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ConnectionValidation' element does not require an additional 'Transport' or 'SODPosition' or 'DataSequence' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ConnectionValidation' Element benötigt keine zusätzliches 'Transport' oder 'SODPosition' oder 'DataSequence' element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation and ./osdd:SODPosition)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation and ./osdd:SODPosition)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ConnectionValidation' element does not require an additional 'Transport' or 'SODPosition' or 'DataSequence' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ConnectionValidation' Element benötigt keine zusätzliches 'Transport' oder 'SODPosition' oder 'DataSequence' element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation and ./osdd:DataSequence)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation and ./osdd:DataSequence)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ConnectionValidation' element does not require an additional 'Transport' or 'SODPosition' or 'DataSequence' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ConnectionValidation' Element benötigt keine zusätzliches 'Transport' oder 'SODPosition' oder 'DataSequence' element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation) or ./osdd:ConnectionValidation and matches(./@Type,'^(Boolean)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation) or ./osdd:ConnectionValidation and matches(./@Type,'^(Boolean)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.boolean.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataValue' attribute 'Type' has to be 'Boolean' if 'ConnectionValidation' element is present.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.connectionvalidation.boolean.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataValue' Attribut 'Type' muss ein 'Boolean' sein wenn das 'ConnectionValidation' Element benutzt wird.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Type='Domain') and not(@NrOfOctets) or @Type='Domain' and @NrOfOctets"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Type='Domain') and not(@NrOfOctets) or @Type='Domain' and @NrOfOctets"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.domain.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>If the 'DataValue' attribute 'Type' is 'Domain' it requires a 'NrOfOctets' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.domain.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'DataValue' Element mit 'Type' Attribut 'Domain' muss ein 'NrOfOctets' Attribut haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@NrOfOctets) or number(./@NrOfOctets) &gt;= 8"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@NrOfOctets) or number(./@NrOfOctets) &gt;= 8"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.datavalue.domain.nrofoctets.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'NrOfOctets': '<xsl:text/><xsl:value-of select="@NrOfOctets"/><xsl:text/>' should not go below '8'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.datavalue.domain.nrofoctets.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'NrOfOctets' Attribut : '<xsl:text/><xsl:value-of select="@NrOfOctets"/><xsl:text/>' sollte nicht unter '8' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='false']" mode="M49" priority="1005"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="groupID" select="string(../@id)"/><xsl:variable name="channelID" select="string(./@id)"/><xsl:variable name="name" select="string-join(($groupID,$channelID),'/')"/><xsl:choose><xsl:when test="not(./osdd:ChannelSettings) or count(//osdd:SettingsGroup[@CopyFromChannel=$name and ancestor::osdd:Module[@id=$currentModule]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ChannelSettings) or count(//osdd:SettingsGroup[@CopyFromChannel=$name and ancestor::osdd:Module[@id=$currentModule]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.copyfromchannel.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' : <xsl:text/><xsl:value-of select="$name"/><xsl:text/> does not have a corresponding 'CopyFromChannel' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.copyfromchannel.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'SafeChannel' : <xsl:text/><xsl:value-of select="$name"/><xsl:text/> hat kein dazugehöriges'CopyFromChannel' Element.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="normalize-space(@id) != '' and @id castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="normalize-space(@id) != '' and @id castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' Attribut 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Name) or normalize-space(@Name) != '' and @Name castable as xs:string"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' attribute 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' must have a valid value and has to have data type xs:string.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' Attribut 'Name' : '<xsl:text/><xsl:value-of select="@Name"/><xsl:text/>' muss einen gültigen Wert haben und muss vom Datentyp xs:string sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./osdd:DataValue"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:DataValue"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataValue'element has to exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataValue' Element muss existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="matches(./osdd:DataValue/@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean|Domain)$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches(./osdd:DataValue/@Type,'^(Int8|Int16|Int24|Int32|Int40|Int48|Int56|Int64|UInt8|UInt16|UInt24|UInt32|UInt40|UInt48|UInt56|UInt64|Float32|Float64|Boolean|Domain)$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataValue' attribute 'Type' has to be an OpenSafety datatype except the 'Void' datatype.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'DataValue' Attribut 'Type' muss ein OpenSafety Datentyp sein und darf nicht 'void' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentChannel" select="@id"/><xsl:choose><xsl:when test="count(./../osdd:Channel[@id=$currentChannel]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(./../osdd:Channel[@id=$currentChannel]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SafeChannel' or 'Channel' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' must be unique inside the 'ChannelGroup'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.name.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SafeChannel' oder 'Channel' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' Element muss innerhalb der 'ChannelGroup' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@displayWithProfile) or @displayWithProfile and count(./osdd:ProfileInfo) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@displayWithProfile) or @displayWithProfile and count(./osdd:ProfileInfo) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.displayWithProfile.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Channel: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> must not have a 'displayWithProfile' attribute because it does not belong to a Profile.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.displayWithProfile.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der Kanal: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> darf kein 'displayWithProfile' Attribut besitzen weil er keinem Profil angehört.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='false']/osdd:DataValue" mode="M49" priority="1004"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="isSafeMotionModule" select="count(//osdd:Profile[text()='SafeMotion' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:variable name="isSafeVisionModule" select="count(//osdd:Profile[text()='Vision' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="($isSafeMotionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')) or ($isSafeVisionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')) or not(./osdd:SODPosition) or matches(./osdd:SODPosition/@Index,'^(0x6[0-3]{1}[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($isSafeMotionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')) or ($isSafeVisionModule = 1 and matches(./osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')) or not(./osdd:SODPosition) or matches(./osdd:SODPosition/@Index,'^(0x6[0-3]{1}[0-9a-fA-F]{2})$')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.sodposition.format.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@Index)"/><xsl:text/>' defines a profile object but there is no profile defined for the module.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.sodposition.format.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribut 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@Index)"/><xsl:text/>' definiert ein Profilobjekt aber es ist kein Profil für das Modul definiert.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:SODPosition) or matches(./osdd:SODPosition/@SubIndex,'^(0x[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:SODPosition) or matches(./osdd:SODPosition/@SubIndex,'^(0x[0-9a-fA-F]{2})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.format.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'SubIndex' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@SubIndex)"/><xsl:text/>' does not match the specified range.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.format.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribut 'SubIndex' : '<xsl:text/><xsl:value-of select="string(./osdd:SODPosition/@SubIndex)"/><xsl:text/>' stimmt nicht mit dem spezifizierten Format überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentIndex" select="./osdd:SODPosition/@Index"/><xsl:variable name="currentSubIndex" select="./osdd:SODPosition/@SubIndex"/><xsl:choose><xsl:when test="not(./osdd:SODPosition)     or      ((count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 8     and      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1)     and      not(      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0     and      count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)]       and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:SODPosition) or ((count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 8 and count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &lt;= 1) and not( count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[@Type=&quot;Boolean&quot;] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 and count(//osdd:SODPosition[@Index=$currentIndex and @SubIndex=$currentSubIndex and ..[not(@Type=&quot;Boolean&quot;)] and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.unique.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' element with 'Index' : '<xsl:text/><xsl:value-of select="$currentIndex"/><xsl:text/>' and 'SubIndex' : <xsl:text/><xsl:value-of select="$currentSubIndex"/><xsl:text/> has to be unique within the 'Module'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.sodposition.subindex.unique.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Element mit 'Index' : '<xsl:text/><xsl:value-of select="$currentIndex"/><xsl:text/>' und 'SubIndex' : <xsl:text/><xsl:value-of select="$currentSubIndex"/><xsl:text/> muss im 'Module' einzigartig sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./osdd:Transport"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:Transport"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' element must exist within a 'ChannelConfiguration' if no 'ConnectionValidation' element exist.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Element muss in einer 'ChannelConfiguration' existieren wenn kein 'ConnectionValidation' Element existiert.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentspdo" select="string(./osdd:Transport/@Name)"/><xsl:choose><xsl:when test="not(./osdd:Transport/@Name) or count(//osdd:SPDOTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 or count(//osdd:DataTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:ACyclicTransport]) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport/@Name) or count(//osdd:SPDOTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) &gt; 0 or count(//osdd:DataTransport[@Name=$currentspdo and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease] and ancestor::osdd:ACyclicTransport]) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.exist.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentspdo"/><xsl:text/>' element could not be referenced to an existing 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.exist.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentspdo"/><xsl:text/>' Element kann nicht mit einem 'SPDOTransport' Element referenziert werden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(./osdd:Transport) or matches(./osdd:Transport/@Index,'^(0x[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport) or matches(./osdd:Transport/@Index,'^(0x[0-9a-fA-F]{2})$')"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.index.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@Index)"/><xsl:text/>' does not match the specified range.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.index.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Attribut 'Index' : '<xsl:text/><xsl:value-of select="string(./osdd:Transport/@Index)"/><xsl:text/>' stimmt nicht mit dem spezifizierten Format überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="./osdd:Transport/@Name"/><xsl:variable name="currentSPDOPos" select="myFunction:hex2dec(./osdd:Transport/@Index)"/><xsl:variable name="test" select="./osdd:DataSequence/@RangeMax"/><xsl:variable xmlns="http://purl.oclc.org/dsdl/schematron" xmlns:dp="http://www.dpawson.co.uk/ns#" name="currentRange"><xsl:choose><xsl:when test="./osdd:DataSequence/@RangeMax"><xsl:value-of select="number(./osdd:DataSequence/@RangeMax - ./osdd:DataSequence/@RangeMin)"/></xsl:when><xsl:otherwise><xsl:value-of select="1"/></xsl:otherwise></xsl:choose></xsl:variable><xsl:variable name="currentSPDODataSize" select="myFunction:typeSize(@Type)"/><xsl:variable name="currentComplete" select="ceiling($currentSPDOPos + $currentSPDODataSize * $currentRange)"/><xsl:variable name="currentOctetSize" select="../../../osdd:DataTransport/osdd:SPDOTransport[@Name =$currentSPDO]/@OctetSize"/><xsl:variable name="currentChannel" select="../@id"/><xsl:choose><xsl:when test="not(./osdd:Transport) or ./osdd:ConnectionValidation or $currentOctetSize &gt;= $currentComplete"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport) or ./osdd:ConnectionValidation or $currentOctetSize &gt;= $currentComplete"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Channel' : '<xsl:text/><xsl:value-of select="$currentChannel"/><xsl:text/>' would require the 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' to have at least : '<xsl:text/><xsl:value-of select="$currentComplete"/><xsl:text/>' octets but only has : '<xsl:text/><xsl:value-of select="$currentOctetSize"/><xsl:text/>' octets.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der 'Channel' : '<xsl:text/><xsl:value-of select="$currentChannel"/><xsl:text/>' benötigt ein 'SPDOTransport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' mit mindestens : '<xsl:text/><xsl:value-of select="$currentComplete"/><xsl:text/>' Oktets, aber hat nur : '<xsl:text/><xsl:value-of select="$currentOctetSize"/><xsl:text/>' Oktets.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="string(./osdd:Transport/@Name)"/><xsl:variable name="currentSPDOPos" select="./osdd:Transport/@Index"/><xsl:choose><xsl:when test="./osdd:ConnectionValidation or @Type ='Boolean' or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or @Type ='Boolean' or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.count.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' attribute 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' is already used within the 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.count.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' Attribut 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' wird im 'SPDOTransport' bereits benutzt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:variable name="currentSPDO" select="string(./osdd:Transport/@Name)"/><xsl:variable name="currentSPDOPos" select="./osdd:Transport/@Index"/><xsl:variable name="currentBitMask" select="./osdd:Transport/@BitMask"/><xsl:choose><xsl:when test="./osdd:ConnectionValidation or not(./osdd:Transport) or not(@Type='Boolean') or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and not(@BitMask) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and @BitMask=$currentBitMask and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or not(./osdd:Transport) or not(@Type='Boolean') or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and not(@BitMask) and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1 or count(//osdd:Transport[@Name=$currentSPDO and @Index=$currentSPDOPos and @BitMask=$currentBitMask and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]]) = 1"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.count.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>' : 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' attribute 'Bitmask' : '<xsl:text/><xsl:value-of select="$currentBitMask"/><xsl:text/>' does not exist or is already used within the 'SPDOTransport'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.count.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' : '<xsl:text/><xsl:value-of select="$currentSPDO"/><xsl:text/>'  : 'Index' : '<xsl:text/><xsl:value-of select="$currentSPDOPos"/><xsl:text/>' Attribut 'Bitmask' : '<xsl:text/><xsl:value-of select="$currentBitMask"/><xsl:text/>' wird im 'SPDOTransport' bereits benutzt oder ist nicht vorhanden.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="./osdd:ConnectionValidation or not(@Type = 'Boolean') and not(./osdd:Transport/@BitMask) or @Type='Boolean'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="./osdd:ConnectionValidation or not(@Type = 'Boolean') and not(./osdd:Transport/@BitMask) or @Type='Boolean'"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.type.check.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Transport' attribute 'BitMask' must not exist with other 'DataValue' : 'Type' than 'Boolean'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.Transport.bitmask.type.check.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'Transport' Attribut 'BitMask' darf nur bei 'DataValue' : 'Type' : 'Boolean' existieren.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:if test="not(./osdd:Transport/@BitMask) and not(./osdd:ConnectionValidation)"><svrl:successful-report xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:Transport/@BitMask) and not(./osdd:ConnectionValidation)"><xsl:attribute name="role">report</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.bitmask.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Transport attribute BitMask uses default value : '0x01'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.report.osdd.usedefault.bitmask.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das Transport Attribut BitMask benutzt die Standardeinstellung: '0x01'.</svrl:diagnostic-reference></svrl:successful-report></xsl:if><xsl:choose><xsl:when test="not(./osdd:ConnectionValidation)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(./osdd:ConnectionValidation)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.Transport.connectionvalidation.en"><xsl:attribute name="xml:lang">en</xsl:attribute>A Non-Safe 'Channel' : '<xsl:text/><xsl:value-of select="../@id"/><xsl:text/>' can not have a 'ConnectionValidation' element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.Transport.connectionvalidation.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein nicht sicherer 'Channel' : '<xsl:text/><xsl:value-of select="../@id"/><xsl:text/>' darf kein 'ConnectionValidation' Element enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@Type='Domain') and not(@NrOfOctets) or @Type='Domain' and @NrOfOctets"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@Type='Domain') and not(@NrOfOctets) or @Type='Domain' and @NrOfOctets"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.domain.type.en"><xsl:attribute name="xml:lang">en</xsl:attribute>If the 'DataValue' attribute 'Type' is 'Domain' it requires a 'NrOfOctets' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.safechannel.datavalue.domain.type.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Ein 'DataValue' Element mit 'Type' Attribut 'Domain' muss ein 'NrOfOctets' Attribut haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(@NrOfOctets) or number(./@NrOfOctets) &gt;= 8"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@NrOfOctets) or number(./@NrOfOctets) &gt;= 8"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.datavalue.domain.nrofoctets.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'NrOfOctets': '<xsl:text/><xsl:value-of select="@NrOfOctets"/><xsl:text/>' should not go below '8'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.warning.osdd.channelconfig.safechannel.datavalue.domain.nrofoctets.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'NrOfOctets' Attribut : '<xsl:text/><xsl:value-of select="@NrOfOctets"/><xsl:text/>' sollte nicht unter '8' sein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='false']/osdd:ChannelSettings" mode="M49" priority="1003"><xsl:choose><xsl:when test="count(child::node()) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(child::node()) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ChannelSettings' element has to include 'Setting' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ChannelSettings' Element muss 'Setting' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not(ancestor::osdd:ChannelGroup[@CopyToAllSN='true'])"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(ancestor::osdd:ChannelGroup[@CopyToAllSN='true'])"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.copytoallsn.en"><xsl:attribute name="xml:lang">en</xsl:attribute>If a 'ChannelSettings' element exist the ChannelGroup must not have the CopyToAllSN attribute set to 'true'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.copytoallsn.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Wenn ein 'ChannelSettings' Element existiert dann darf die ChannelGroup das CopyToAllSN nicht auf 'true' gesetzt haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel[@isSafe='true']/osdd:ChannelSettings" mode="M49" priority="1002"><xsl:choose><xsl:when test="count(child::node()) &gt; 0"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(child::node()) &gt; 0"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ChannelSettings' element has to include 'Setting' elements.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.channelsettings.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ChannelSettings' Element muss 'Setting' Elemente enthalten.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel/osdd:RelationWith/*/osdd:ChannelRef" mode="M49" priority="1001"><xsl:variable name="currentChannelID" select="ancestor::osdd:Channel/@id"/><xsl:choose><xsl:when test="$currentChannelID != @id"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$currentChannelID != @id"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.relationwith.id.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The Channel: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> must not have relation with itself.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.relationwith.id.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der Kanal: <xsl:text/><xsl:value-of select="@id"/><xsl:text/> darf keine Abhängigkeit zu sich selbst haben.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel/osdd:ProfileInfo/osdd:ProfileRepetition" mode="M49" priority="1000"><xsl:choose><xsl:when test="number(@RangeMax) = number(../../osdd:Repetition/@RangeMax)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="number(@RangeMax) = number(../../osdd:Repetition/@RangeMax)"><xsl:attribute name="role">error</xsl:attribute><svrl:text></svrl:text> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.repetition.maxrange.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The ProfileRepetition @ RangeMax: <xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/> does not fit the channel repetition @RangeMax: <xsl:text/><xsl:value-of select="../../osdd:Repetition/@RangeMax"/><xsl:text/> or there is no channel repetition element.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.channelconfig.channel.repetition.maxrange.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die ProfileRepetition @ RangeMax: <xsl:text/><xsl:value-of select="@RangeMax"/><xsl:text/> stimmt nicht mit dem Kanal Repetition @RangeMax: <xsl:text/><xsl:value-of select="../../osdd:Repetition/@RangeMax"/><xsl:text/> überein oder es gibt keine zugehöriges Repetition Element im Kanal.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="text()" mode="M49" priority="-1"/><xsl:template match="@*|node()" mode="M49" priority="-2"><xsl:apply-templates mode="M49" select="*"/></xsl:template><xsl:template match="//*[@Type and @Value]" mode="M50" priority="1004"><xsl:variable name="float_check" select="myFunction:checkFloat(./@Value)"/><xsl:variable name="value" select="myFunction:hex2dec(./@Value)"/><xsl:variable name="numberCheck" select="myFunction:typeCheck(./@Type,$value)"/><xsl:choose><xsl:when test="self::osdd:DataAlignment or number($numberCheck) = 1 and number($float_check) = 0 or number($numberCheck) = 2 and number($float_check) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="self::osdd:DataAlignment or number($numberCheck) = 1 and number($float_check) = 0 or number($numberCheck) = 2 and number($float_check) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' datatype has invalid value : '<xsl:text/><xsl:value-of select="@Value"/><xsl:text/>'. Datatype overflow definition not allowed.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Der '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' Datentyp hat einen ungültigen Wert : '<xsl:text/><xsl:value-of select="@Value"/><xsl:text/>'. Definition eines Datentypüberlaufs nicht erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="//*[text()[string-length(normalize-space(.)) &gt; 0]]" mode="M50" priority="1003"><xsl:choose><xsl:when test="string-length(normalize-space(.)) = string-length(.)"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string-length(normalize-space(.)) = string-length(.)"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.whitespace.en"><xsl:attribute name="xml:lang">en</xsl:attribute>Leading or trailing whitespace error in OSDD element : "<xsl:text/><xsl:value-of select="name(.)"/><xsl:text/>" : "<xsl:text/><xsl:value-of select="."/><xsl:text/>"</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.whitespace.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Leerzeichenfehler in OSDD Element : "<xsl:text/><xsl:value-of select="name(.)"/><xsl:text/>" : "<xsl:text/><xsl:value-of select="."/><xsl:text/>"</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="//osdd:Entry" mode="M50" priority="1002"><xsl:variable name="currentType" select="string(../@Type)"/><xsl:variable name="currentValue" select="@Value"/><xsl:choose><xsl:when test="myFunction:typeCheck($currentType,$currentValue) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:typeCheck($currentType,$currentValue) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.choice.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Choice' : '<xsl:text/><xsl:value-of select="../@Name"/><xsl:text/>' with '<xsl:text/><xsl:value-of select="$currentType"/><xsl:text/>' datatype has invalid value : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>'.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.choice.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'Choice' : '<xsl:text/><xsl:value-of select="../@Name"/><xsl:text/>' mit '<xsl:text/><xsl:value-of select="$currentType"/><xsl:text/>' Datentyp hat einen ungültigen Wert : '<xsl:text/><xsl:value-of select="$currentValue"/><xsl:text/>'.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="//osdd:RangeDefinition" mode="M50" priority="1001"><xsl:variable name="currentType" select="string(../@Type)"/><xsl:variable name="currentRangeMin" select="@RangeMin"/><xsl:variable name="currentRangeMax" select="@RangeMax"/><xsl:variable name="currentStepSize" select="@StepSize"/><xsl:choose><xsl:when test="myFunction:typeCheck($currentType,$currentRangeMin) = 1 and myFunction:typeCheck($currentType,$currentRangeMax) = 1 and (myFunction:typeCheck($currentType,$currentStepSize) = 1 or not(@StepSize))"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:typeCheck($currentType,$currentRangeMin) = 1 and myFunction:typeCheck($currentType,$currentRangeMax) = 1 and (myFunction:typeCheck($currentType,$currentStepSize) = 1 or not(@StepSize))"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.range.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'Range' : '<xsl:text/><xsl:value-of select="../@Name"/><xsl:text/>' with '<xsl:text/><xsl:value-of select="../@Type"/><xsl:text/>' datatype has invalid 'RangeMin', 'RangeMax' or 'StepSize' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.range.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'Range' : '<xsl:text/><xsl:value-of select="../@Name"/><xsl:text/>' mit '<xsl:text/><xsl:value-of select="../@Type"/><xsl:text/>' Datentyp hat ein ungültiges 'RangeMin', 'RangeMax' oder 'StepSize' Attribut.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="//osdd:DataSelection" mode="M50" priority="1000"><xsl:variable name="currentType" select="string(@Type)"/><xsl:variable name="currentRangeMin" select="@RangeMin"/><xsl:variable name="currentRangeMax" select="@RangeMax"/><xsl:variable name="currentStepSize" select="@RangeStep"/><xsl:variable name="currentDefault" select="@Default"/><xsl:choose><xsl:when test="myFunction:typeCheck($currentType,$currentRangeMin) = 1 and myFunction:typeCheck($currentType,$currentRangeMax) = 1 and (myFunction:typeCheck($currentType,$currentStepSize) = 1 or not(@RangeStep)) and myFunction:typeCheck($currentType,$currentDefault) = 1"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="myFunction:typeCheck($currentType,$currentRangeMin) = 1 and myFunction:typeCheck($currentType,$currentRangeMax) = 1 and (myFunction:typeCheck($currentType,$currentStepSize) = 1 or not(@RangeStep)) and myFunction:typeCheck($currentType,$currentDefault) = 1"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.dataselection.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'DataSelection' with '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' datatype has invalid 'RangeMin', 'RangeMax', 'RangeStep' or 'Default' attribute.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.datatype.dataselection.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Die 'DataSelection' mit '<xsl:text/><xsl:value-of select="@Type"/><xsl:text/>' Datentyp hat ein ungültiges 'RangeMin', 'RangeMax', 'RangeStep' oder 'Default' Attribut.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="text()" mode="M50" priority="-1"/><xsl:template match="@*|node()" mode="M50" priority="-2"><xsl:apply-templates mode="M50" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel/osdd:ProfileInfo" mode="M51" priority="1000"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="isSafeMotionModule" select="count(//osdd:Profile[text()='SafeMotion' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="not($isSafeMotionModule = 1) or @id='oSM_AxisId' or @id='oSM_SetId' or @id='oSM_SetFunction' or @id='oSM_FunctionType'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($isSafeMotionModule = 1) or @id='oSM_AxisId' or @id='oSM_SetId' or @id='oSM_SetFunction' or @id='oSM_FunctionType'"><xsl:attribute name="role">error</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safemotion.profile.info.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ProfileInfo' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' is not allowed within the openSAFETY Motion Profile.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safemotion.profile.info.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ProfileInfo' Attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' ist im openSAFETY Motion Profil nicht erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not($isSafeMotionModule = 1) or matches(../osdd:DataValue/osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($isSafeMotionModule = 1) or matches(../osdd:DataValue/osdd:SODPosition/@Index,'^(0x6[5-7]{1}[0-9a-fA-F]{2})$')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safemotion.profile.SODPosition.index.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(../osdd:DataValue/osdd:SODPosition/@Index)"/><xsl:text/>' does not match the openSAFETY Motion Profile range (0x6500 - 0x6700).</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safemotion.profile.SODPosition.index.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribute 'Index' : '<xsl:text/><xsl:value-of select="../osdd:DataValue/osdd:SODPosition/@Index"/><xsl:text/>' stimmt nicht mit der openSAFETY Motion Profil Indexrange (0x6500 - 0x6700) überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M51" select="*"/></xsl:template><xsl:template match="text()" mode="M51" priority="-1"/><xsl:template match="@*|node()" mode="M51" priority="-2"><xsl:apply-templates mode="M51" select="*"/></xsl:template><xsl:template match="osdd:osdd/osdd:Module/osdd:ChannelConfiguration/osdd:ChannelGroup/osdd:Channel/osdd:ProfileInfo" mode="M52" priority="1000"><xsl:variable name="currentModule" select="ancestor::osdd:Module/@id"/><xsl:variable name="currentSafetyRelease" select="ancestor::osdd:Module/@openSafetyRelease"/><xsl:variable name="isSafeVisionModule" select="count(//osdd:Profile[text()='Vision' and ancestor::osdd:Module[@id=$currentModule and @openSafetyRelease=$currentSafetyRelease]])"/><xsl:choose><xsl:when test="not($isSafeVisionModule = 1) or (@id='oSP_FunctionGroupId' and @profile='Vision') or @id='oSP_SetId' or @id='oSP_SetFunction' or @id='oSP_FunctionType'"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($isSafeVisionModule = 1) or (@id='oSP_FunctionGroupId' and @profile='Vision') or @id='oSP_SetId' or @id='oSP_SetFunction' or @id='oSP_FunctionType'"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safevision.profile.info.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'ProfileInfo' attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' is not allowed within the openSAFETY Vision Profile.</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safevision.profile.info.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'ProfileInfo' Attribute 'id' : '<xsl:text/><xsl:value-of select="@id"/><xsl:text/>' ist im openSAFETY Vision Profil nicht erlaubt.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="not($isSafeVisionModule = 1) or matches(../osdd:DataValue/osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')"/><xsl:otherwise><svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($isSafeVisionModule = 1) or matches(../osdd:DataValue/osdd:SODPosition/@Index,'^(0x6[8-9]{1}[0-9a-fA-F]{2})$')"><xsl:attribute name="role">warning</xsl:attribute><svrl:text/> <svrl:diagnostic-reference diagnostic="linenumber"><xsl:text/><xsl:value-of select="saxon:line-number()"/><xsl:text/></svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safevision.profile.SODPosition.index.en"><xsl:attribute name="xml:lang">en</xsl:attribute>The 'SODPosition' attribute 'Index' : '<xsl:text/><xsl:value-of select="string(../osdd:DataValue/osdd:SODPosition/@Index)"/><xsl:text/>' does not match the openSAFETY Vision Profile range (0x6800 - 0x6900).</svrl:diagnostic-reference> <svrl:diagnostic-reference diagnostic="diag.error.osdd.safevision.profile.SODPosition.index.de"><xsl:attribute name="xml:lang">de</xsl:attribute>Das 'SODPosition' Attribute 'Index' : '<xsl:text/><xsl:value-of select="../osdd:DataValue/osdd:SODPosition/@Index"/><xsl:text/>' stimmt nicht mit der openSAFETY Vision Profil Indexrange (0x6800 - 0x6900) überein.</svrl:diagnostic-reference></svrl:failed-assert></xsl:otherwise></xsl:choose><xsl:apply-templates mode="M52" select="*"/></xsl:template><xsl:template match="text()" mode="M52" priority="-1"/><xsl:template match="@*|node()" mode="M52" priority="-2"><xsl:apply-templates mode="M52" select="*"/></xsl:template></xsl:stylesheet>