/*
 * Decompiled with CFR 0.152.
 */
package org.epsg.powerlink.check;

import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XslTransformerUtils {
    private XslTransformerUtils() {
    }

    static TransformerFactory getTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://saxon.sf.net/feature/linenumbering", true);
        transformerFactory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", true);
        transformerFactory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", 0);
        return transformerFactory;
    }

    public static void xsltTransform(StreamSource streamSource, InputStream inputStream, StreamResult streamResult, Map<String, String> map) throws TransformerException {
        TransformerFactory transformerFactory = XslTransformerUtils.getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(inputStream));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            transformer.setParameter(entry.getKey(), entry.getValue());
        }
        transformer.transform(streamSource, streamResult);
    }
}

