/*
 * Decompiled with CFR 0.152.
 */
package org.epsg.powerlink.check;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.epsg.powerlink.check.CommandLineMain;
import org.epsg.powerlink.check.XslTransformerUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XddCommandLineWorker {
    private File fileToCheck;
    private Map<String, String> parameterMap;

    public XddCommandLineWorker(File file, String string, boolean bl) {
        this.fileToCheck = file;
        this.parameterMap = new HashMap<String, String>();
    }

    public void startClValidation() {
        try {
            String string = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime());
            this.parameterMap.put("prmCreatedBy", System.getProperty("user.name"));
            this.parameterMap.put("prmCreatedOn", string);
            this.parameterMap.put("prmCheckerVersion", "v1.1.0");
            this.parameterMap.put("prmXddSchemaVersion", "v0.16");
            FileInputStream fileInputStream = new FileInputStream(this.fileToCheck);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.fileToCheck);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("count(//GeneralFeatures[@DLLFeatureMN = 'true'])");
            if (((Boolean)xPathExpression.evaluate(document, XPathConstants.BOOLEAN)).booleanValue()) {
                ((InputStream)fileInputStream).close();
                throw new IOException("Checking of Managing Node XDDs is not supported.");
            }
            InputStream inputStream = CommandLineMain.class.getResourceAsStream("/resources/xdd_check.xsl");
            URL uRL = CommandLineMain.class.getResource("/resources/xdd/Powerlink_Main.xsd");
            SaxErrorHandler saxErrorHandler = new SaxErrorHandler();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(uRL);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setSchema(schema);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)saxErrorHandler);
            if (saxErrorHandler.validationErrors.size() != 0) {
                ((InputStream)fileInputStream).close();
                byteArrayOutputStream2.close();
                byteArrayOutputStream.close();
                inputStream.close();
                return;
            }
            FileInputStream fileInputStream2 = new FileInputStream(this.fileToCheck);
            String string2 = DigestUtils.md5Hex(fileInputStream2);
            this.parameterMap.put("prmMd5", string2);
            fileInputStream2.close();
            XslTransformerUtils.xsltTransform(new StreamSource(this.fileToCheck), inputStream, new StreamResult(byteArrayOutputStream), this.parameterMap);
            InputStream inputStream2 = CommandLineMain.class.getResourceAsStream("/resources/xdd_report.xsl");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.parameterMap.put("prmReportFilename", FilenameUtils.removeExtension(this.fileToCheck.getName()) + ".html");
            XslTransformerUtils.xsltTransform(new StreamSource(byteArrayInputStream), inputStream2, new StreamResult(byteArrayOutputStream2), this.parameterMap);
            FileOutputStream fileOutputStream = new FileOutputStream(FilenameUtils.removeExtension(this.fileToCheck.getAbsolutePath()) + ".html");
            byteArrayOutputStream2.writeTo(fileOutputStream);
            ((InputStream)fileInputStream).close();
            byteArrayOutputStream2.close();
            byteArrayOutputStream.close();
            inputStream2.close();
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)SAXParseException.class.cast(exception);
                CommandLineMain.writeExceptionLog("Fatal Error", sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
            } else {
                CommandLineMain.writeExceptionLog(exception);
            }
            return;
        }
    }

    private static class SaxErrorHandler
    extends DefaultHandler {
        private List<String> validationErrors = new ArrayList<String>();

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            CommandLineMain.writeExceptionLog("Error", sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            CommandLineMain.writeExceptionLog("Fatal Error", sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            CommandLineMain.writeExceptionLog("Warning", sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
        }
    }
}

