/*
 * Decompiled with CFR 0.152.
 */
package org.epsg.powerlink.check;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.epsg.powerlink.check.CommandLineMain;
import org.epsg.powerlink.check.XslTransformerUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OsddCommandLineWorker {
    private final String languageOutput;
    private final File fileToProcess;
    private String outputFileName;
    private final ByteArrayOutputStream internalOutputXML;
    private final ByteArrayOutputStream internalOutputHTML;
    private ByteArrayInputStream internalInputStreamHTML;
    private Source streamSourceOsddInput;
    private SchemaFactory schemaFactoryOsddSchema;
    private Schema schemaOsdd;
    private Validator validatorOsdd;
    private boolean validateSuccessfulFlag;
    private boolean transformSuccessfulFlag;
    private boolean outputSuccessfulFlag;
    private String md5;

    public OsddCommandLineWorker(File file, String string) {
        this.fileToProcess = file;
        this.languageOutput = string;
        this.internalOutputXML = new ByteArrayOutputStream();
        this.internalOutputHTML = new ByteArrayOutputStream();
        this.validateSuccessfulFlag = false;
        this.transformSuccessfulFlag = false;
        this.outputSuccessfulFlag = false;
    }

    public void startClValidation() {
        Exception exception;
        try {
            this.streamSourceOsddInput = new StreamSource(this.fileToProcess);
            this.schemaFactoryOsddSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schemaOsdd = this.schemaFactoryOsddSchema.newSchema(new StreamSource(CommandLineMain.class.getResourceAsStream("/resources/osdd/XOSDD_R15.xsd")));
            this.validatorOsdd = this.schemaOsdd.newValidator();
            this.validatorOsdd.validate(this.streamSourceOsddInput);
            this.validateSuccessfulFlag = true;
            FileInputStream fileInputStream = new FileInputStream(this.fileToProcess);
            this.md5 = DigestUtils.md5Hex(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            CommandLineMain.writeExceptionLog(iOException);
        }
        catch (SAXException sAXException) {
            exception = (SAXParseException)SAXParseException.class.cast(sAXException);
            CommandLineMain.writeExceptionLog("Fatal Error", ((SAXException)exception).getMessage(), ((SAXParseException)exception).getLineNumber(), ((SAXParseException)exception).getColumnNumber());
        }
        try {
            if (this.validateSuccessfulFlag) {
                this.xsltTransform(new StreamSource(this.fileToProcess), "osdd_check.xsl", new StreamResult(this.internalOutputXML));
                this.internalInputStreamHTML = new ByteArrayInputStream(this.internalOutputXML.toByteArray());
                this.transformSuccessfulFlag = true;
                if (this.transformSuccessfulFlag) {
                    this.xsltTransformAttributes(new StreamSource(this.internalInputStreamHTML), "osdd_report.xsl", new StreamResult(this.internalOutputHTML), true, false, this.languageOutput);
                    this.internalInputStreamHTML.close();
                    this.outputSuccessfulFlag = true;
                }
            }
        }
        catch (TransformerException transformerException) {
            exception = (TransformerException)TransformerException.class.cast(transformerException);
            CommandLineMain.writeExceptionLog("Fatal Error", ((TransformerException)exception).getMessageAndLocation(), 0, 0);
        }
        catch (IOException iOException) {
            CommandLineMain.writeExceptionLog(iOException);
        }
        if (this.validateSuccessfulFlag && this.transformSuccessfulFlag && this.outputSuccessfulFlag) {
            this.outputFileName = new String(FilenameUtils.removeExtension(this.fileToProcess.getName()));
            try {
                FileUtils.write(new File(this.fileToProcess.getParent(), this.outputFileName + ".html"), (CharSequence)StringEscapeUtils.unescapeHtml4(this.internalOutputHTML.toString()), false);
            }
            catch (IOException iOException) {
                CommandLineMain.writeExceptionLog(iOException);
            }
        }
    }

    private void xsltTransform(StreamSource streamSource, String string, StreamResult streamResult) throws TransformerException {
        TransformerFactory transformerFactory = XslTransformerUtils.getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(OsddCommandLineWorker.class.getResourceAsStream("/resources/" + string)));
        transformer.transform(streamSource, streamResult);
    }

    private void xsltTransformAttributes(StreamSource streamSource, String string, StreamResult streamResult, boolean bl, boolean bl2, String string2) throws TransformerException {
        TransformerFactory transformerFactory = XslTransformerUtils.getTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(OsddCommandLineWorker.class.getResourceAsStream("/resources/" + string)));
        transformer.setParameter("lang", string2);
        transformer.setParameter("showWarning", bl);
        transformer.setParameter("showReport", bl2);
        transformer.setParameter("username", System.getProperty("user.name"));
        transformer.setParameter("os", System.getProperty("os.name") + ", " + System.getProperty("os.arch"));
        transformer.setParameter("md5", this.md5);
        transformer.setParameter("fileName", FilenameUtils.removeExtension(this.fileToProcess.getName()));
        transformer.transform(streamSource, streamResult);
    }
}

