/*
 * Decompiled with CFR 0.152.
 */
package org.epsg.powerlink.check;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.epsg.powerlink.check.OsddCommandLineWorker;
import org.epsg.powerlink.check.XddCommandLineWorker;

public final class CommandLineMain {
    private static String path;
    private static String md5;

    private CommandLineMain() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            File file = new File(stringArray[0]);
            String string = FilenameUtils.getExtension(file.getName());
            if (file.exists() && string.equals("xdd") || string.equals("XDD")) {
                CommandLineMain.createMd5(file);
                path = file.getAbsolutePath();
                CommandLineMain.callWorker(file, "en", false);
            } else if (file.exists() && string.equals("xosdd") || string.equals("XOSDD")) {
                CommandLineMain.createMd5(file);
                path = file.getAbsolutePath();
                CommandLineMain.callOsddWorker(file, "English", false);
            }
        } else {
            System.out.println("POWERLINK XDD and openSAFETY OSDD Device Description Checker - " + CommandLineMain.class.getPackage().getImplementationVersion());
            System.out.println("Tool Usage:");
            System.out.println("java -jar device_description_check.jar [input_file]");
            System.out.println("XDD / OSDD Input Files:");
            System.out.println("*.xdd, *.XDD, *.xosdd, *.XOSDD");
        }
    }

    private static void createMd5(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            md5 = DigestUtils.md5Hex(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            md5 = "Cannot create MD5";
            iOException.printStackTrace();
        }
    }

    private static void callWorker(File file, String string, boolean bl) {
        XddCommandLineWorker xddCommandLineWorker = new XddCommandLineWorker(file, string, bl);
        xddCommandLineWorker.startClValidation();
    }

    private static void callOsddWorker(File file, String string, boolean bl) {
        OsddCommandLineWorker osddCommandLineWorker = new OsddCommandLineWorker(file, string);
        osddCommandLineWorker.startClValidation();
    }

    public static void writeExceptionLog(Exception exception) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            CommandLineMain.writeHtmlHeader(stringBuilder);
            stringBuilder.append("<tr><td><b>Category</b></td><td><b>Message</b></td></tr>");
            stringBuilder.append("<tr><td>Fatal Error</td><td>" + exception.getMessage() + "</td></tr>");
            stringBuilder.append("</table></body></html>");
            FileUtils.write(new File(FilenameUtils.removeExtension(path) + ".html"), (CharSequence)stringBuilder.toString(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void writeExceptionLog(String string, String string2, int n, int n2) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            CommandLineMain.writeHtmlHeader(stringBuilder);
            stringBuilder.append("<tr><td><b>Category</b></td><td><b>Line</b></td><td><b>Column</b></td><td><b>Message</b></td></tr>");
            stringBuilder.append("<tr><td>" + string + "</td><td>" + n + "</td><td>" + n2 + "</td><td>" + string2 + "</td></tr>");
            stringBuilder.append("</table></body></html>");
            FileUtils.write(new File(FilenameUtils.removeExtension(path) + ".html"), (CharSequence)stringBuilder.toString(), false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeHtmlHeader(StringBuilder stringBuilder) {
        stringBuilder.append("<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /><title>");
        if (FilenameUtils.getExtension(path).equals("xdd") || FilenameUtils.getExtension(path).equals("XDD")) {
            stringBuilder.append("POWERLINK ");
        } else {
            stringBuilder.append("openSAFETY ");
        }
        stringBuilder.append("Device Description Validation-Result</title><style type='text/css'>body { font-family:'Times New Roman';\tfont-size:12pt; } img.centered { display:block; margin-left:auto;\tmargin-right:auto; } *.centered { margin-left:auto;\tmargin-right:auto; } table.headerTable { border-style:none;\tborder-width:thin; height:50px; border-collapse:collapse; }\ttable.headerTable td { border-style:none; border-width:thin; }\ttable.indented { margin-left:20px; } h1, h2, h3 {\ttext-decoration:underline; page-break-after:avoid; } table.results\t{ border-style:solid; border-width:thin; border-collapse:collapse;\t} table.results td { border-style:solid; border-width:thin; }\ttable.results th { border-style:solid; border-width:medium;\tpadding-left:5px; padding-right:5px; }</style></head><body><table class='headerTable centered'><tr><td width='220px' style='background-color:#ff8800;'>B&amp;R Industrial Automation GmbH<br/>B&amp;R Strasse 1<br />5142 Eggelsberg, Austria<br/>Phone: +43 7748 6586 0<br/>office@br-automation.com<br/>www.br-automation.com<br/></td><td>");
        stringBuilder.append("</td></tr></table><h2 style='text-align:center; margin-bottom:50px;'>");
        if (FilenameUtils.getExtension(path).equals("xdd") || FilenameUtils.getExtension(path).equals("XDD")) {
            stringBuilder.append("POWERLINK ");
        } else {
            stringBuilder.append("openSAFETY ");
        }
        stringBuilder.append("Device Description Validation-Result</h2><h3>Test-Execution</h3>");
        stringBuilder.append("<table class='indented'>");
        stringBuilder.append("</td></tr><tr><td>Report file name:</td><td>");
        stringBuilder.append(FilenameUtils.getName(FilenameUtils.removeExtension(path) + ".html"));
        stringBuilder.append("<tr><td>Report created on:</td><td>");
        stringBuilder.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime()));
        stringBuilder.append("</td></tr></table>");
        stringBuilder.append("<h3>Test-Device Description</h3>");
        stringBuilder.append("<table class='indented'><tr><td>Filename:</td><td>");
        stringBuilder.append(FilenameUtils.getName(path));
        stringBuilder.append("</td></tr><tr><td>File MD5:</td><td>");
        stringBuilder.append(md5);
        stringBuilder.append("</td></tr></table>");
        stringBuilder.append("<h3>Test-Results</h3>");
        stringBuilder.append("<table width='100%' border='1'>");
    }
}

