/********************************************************************
 * COPYRIGHT -- Bernecker + Rainer
 ********************************************************************
 * Program: SdoRead
 * File: SdoRead.c
 * Author: 
 * Created: February 05, 2014
 ********************************************************************
 * Implementation of program SdoRead
 ********************************************************************/

#include <bur/plctypes.h>

#ifdef _DEFAULT_INCLUDES
	#include <AsDefault.h>
#endif

void _INIT SdoRead_init(void)
{

}

void _CYCLIC SdoRead_cyclic(void)
{
	/* Init */
	if (enable)
	{
		/* if not started */
		if (step == 0)
		{
			/* start */
			step = 1;
		}
	}
	else
	{
		/* if not stopped */
		if (step > 0)
		{
			/* stop */
			step = 0;
		}
	}
	
	/* Operation */
	error = 0;
	
	switch (step)
	{
		/* NO OP */
		case 0:
			break;

		/* SDO Read */
		case 1:
			fbkSdoRead.enable = 1;
			fbkSdoRead.pDevice = "IF3";
			fbkSdoRead.node = 1;
			fbkSdoRead.index = 0x1006;
			fbkSdoRead.subindex = 0x00;
			fbkSdoRead.pData = (UDINT)&buffer;
			fbkSdoRead.datalen = sizeof(buffer);
			
			EplSDORead(&fbkSdoRead);
			
			switch (fbkSdoRead.status)
			{
				/* OK */
				case 0:
				case 31344:
					break;
			
				/* BUSY */
				case 65535:
					break;
			
				/* ERROR */
				default:
					step = 255;
					break;
			}
			break;
		
		/* ERROR */
		default:
			error = 1;
			break;
	}
}

void _EXIT SdoRead_exit(void)
{

}
