/********************************************************************
 * COPYRIGHT -- Bernecker + Rainer
 ********************************************************************
 * Program: FloodASnd
 * File: FloodASnd.c
 * Author: 
 * Created: February 06, 2014
 ********************************************************************
 * Implementation of program FloodASnd
 ********************************************************************/

#include <bur/plctypes.h>

#ifdef _DEFAULT_INCLUDES
	#include <AsDefault.h>
#endif

void _INIT FloodASnd_init(void)
{
	/* Open async service ID 5 (SDO) on Node 1 */
	plAcycOpen("IF3/1/5", plOPEN_MODE_EPLV2 | plOPEN_MODE_WRITE, &plIdent);
	
	/* Set SDO init flag */
	buffer[1] = 0x01;
	buflen = sizeof(buffer);
}

void _CYCLIC FloodASnd_cyclic(void)
{
	/* Init */
	if (enable)
	{
		if (!error)
		{
			err = plAcycWrite(plIdent, &buffer, buflen, &lenWritten);
				
			switch (err)
			{
				case 0:
				case 20919:
					break;
					
				default:
					error = 1;
					break;
			}
		}
	}
	else
	{
		/* reset error */
		error = 0;
	}
}

void _EXIT FloodASnd_exit(void)
{
	/* Close the async service ID */
	plAcycClose(plIdent);
}
