(********************************************************************
 * COPYRIGHT -- Bernecker + Rainer
 ********************************************************************
 * Library: powerlnk
 * File: powerlnk.typ
 * Author: B+R
 ********************************************************************
 * Data types of library powerlnk
 ********************************************************************)
                                                                      
TYPE
	PLACTION_GET_DP_INFO_typ : STRUCT           (*query PDO info of datapoint *)
		DeviceName	: UDINT ;					(*in: pointer to the name of the I/O module holding the data point, e.g. "SS1.IF2.ST3.SL7"*)
		ChannelName	: UDINT ;					(*in: pointer to the name of the data point, e.g. "AnalogInput01"*)
		DestNode    : USINT ;                   (*out: Node number of destination *)
		SrcNode     : USINT ;                   (*out: Node number of source *)
		MessageType : USINT ;                   (*out: Message Type on Powerlink (3 PReq, 4 PRes) *)
		MuxSlot     : USINT ;                   (*out: multiplex slot (0 continous station) *)
		OffsetAbs   : UINT ;                    (*out: Offset in net data of EPL frame counted in bits *)
		OffsetRel   : UINT ;                    (*out: Offset relative to station net data in bits *)
		Length      : UINT ;                    (*out: Length of data point counted in bits *)
		TypeId      : UINT ;                    (*out: Type ident of datapoint EPL V2 (matches CANopen Specification) *)
		NodeInSize  : UINT ;                    (*out: input net size of station (Pres) *)
		NodeOutSize : UINT ;                    (*out: output net size of station (normally Preq) *)
		Direction   : USINT ;                   (*out: 1 Input, 2 Output relative to local node *)
		Node        : USINT ;                   (*out: node of datapoint *)
		reserved    : UINT ;                    (*res: reserved word for alignment *)
		ImageIndex  : UDINT ;                   (*out: image index for inputs 0 for outputs *)
		ImageOffset : UDINT ;                   (*out: offset of datapoint in local image buffer (bytes) *)
	END_STRUCT;
	PLACTION_GET_PDO_INFO_typ : STRUCT          (*query PDO info by index / subindex *)
		DeviceName	: UDINT ;					(*in: pointer to the name of the I/O module holding the data point, e.g. "SS1.IF2.ST3.SL7"*)
		ODIndex	    : UINT ;					(*in: Index of object in Powerlink object dictionary *)
		ODSubindex	: USINT ;					(*in: Subindex of object in Powerlink object dictionay *)
		align       : USINT ;                   (*res: reseved for alignment *)
		DestNode    : USINT ;                   (*out: Node number of destination *)
		SrcNode     : USINT ;                   (*out: Node number of source *)
		MessageType : USINT ;                   (*out: Message Type on Powerlink (3 PReq, 4 PRes) *)
		MuxSlot     : USINT ;                   (*out: multiplex slot (0 continous station) *)
		OffsetAbs   : UINT ;                    (*out: Offset in net data of EPL frame counted in bits *)
		OffsetRel   : UINT ;                    (*out: Offset relative to station net data in bits *)
		Length      : UINT ;                    (*out: Length of data point counted in bits *)
		TypeId      : UINT ;                    (*out: Type ident of datapoint EPL V2 (matches CANopen Specification) *)
		NodeInSize  : UINT ;                    (*out: input net size of station (Pres) *)
		NodeOutSize : UINT ;                    (*out: output net size of station (normally Preq) *)
		Direction   : USINT ;                   (*out: 1 Input, 2 Output relative to local node *)
		Node        : USINT ;                   (*out: node of datapoint *)
		reserved    : UINT ;                    (*res: reserved word for alignment *)
		ImageIndex  : UDINT ;                   (*out: image index for inputs 0 for outputs *)
		ImageOffset : UDINT ;                   (*out: offset of datapoint in local image buffer (bytes) *)
	END_STRUCT;
	PLACTION_GET_CROSSLINK_INFO_typ : STRUCT	(*query position of I/O data points in the poll response frame to listen in on inputs from other CNs*)
		DeviceName	: UDINT ;					(*in: pointer to the name of the I/O module holding the data point, e.g. "SS1.IF2.ST3.SL7"*)
		ChannelName	: UDINT ;					(*in: pointer to the name of the data point, e.g. "AnalogInput01"*)
		NodeId	: UINT ;						(*out: node number of POWERLINK station*)
		Offset	: UINT ;						(*out: offset in the data range of the poll response frames in bits*)
		Length	: UINT ;						(*out: size of the data point in the poll response frame in bits*)
		TypeId	: UINT ;						(*out: data type ident of the data point according to the V2 specification*)
	END_STRUCT;	
	PLACTION_DEVICE_TO_BUS_NR_typ : STRUCT		(*determines the POWERLINK bus number from the device definition*)
		pDeviceString	: UDINT ;				(*in: string with the device definition in the form "SLx.SSy.IFz", e.g. "SL0.SS1.IF1", given as a pointer, *)
		busNumber	: USINT ;					(*out: after the function is called, the POWERLINK bus number is in this structure element*)
	END_STRUCT;
	PLACTION_SYNC_STATISTICS_typ : STRUCT		(*reads the times of the synchronous task class*)
		act_usec	: UINT ;					(*out: execution period during the last measured cycle*)
		min_usec	: UINT ;					(*out: minimum execution period*)
		max_usec	: UINT ;					(*out: maximum execution period*)
		act_cycle	: UINT ;					(*out: cycle time during the last measured cycle*)
		min_cycle	: UINT ;					(*out: minimum cycle time*)
		max_cycle	: UINT ;					(*out: maximum cycle time*)
	END_STRUCT;		
	PLSYSCONF_RS_typ : STRUCT					(*this structure is only evaluated on SG3 targets*)
		size_x16	: USINT ;					(*size of the configuration entry in 16 byte blocks*)
		bus	: USINT ;							(*bus number where the remote station is located*)
		station	: USINT ;						(*station number of the station*)
		flags	: USINT ;						(*parameter flags for the station: 16#00 normal station, 16#20 slow station*)
		hwVariant	: UDINT ;					(*hardware variant ID *)
		insize	: INT ;							(*input buffer size of the station*)
		outsize	: INT ;							(*output buffer size of the station*)
		RespTimeout	: INT ;						(*response timeout in s*)
		MuxNetworkSlot	: USINT ;				(*ignored for normal stations, for multiplexed stations 1 to MuxPrescaler*)
		reserve2	: USINT ;					(*reserved for future updates*)
	END_STRUCT;
	PLACTION_GET_IDENT_typ : STRUCT				(*determines a station ID*)
		pName	: UDINT ;						(*string with the station description, e.g. "SL0.SS1.IF1", given as a pointer*)
		ident	: UDINT ;						(*after the function is called, the station ID is located in this structure element*)
	END_STRUCT;		
	PLACTION_NET_QUALITY_typ : STRUCT			(*reads statistic information regarding network quality*)
		nLineQualFreezeCnt	: UDINT ;			(*number of POWERLINK cycles in during the measurement period*)
		nLineQualFailCnt	: UDINT ;			(*number of failed POWERLINK cycles*)
	END_STRUCT;
	PLSYSCONF_IF_typ : STRUCT					(*determines configured POWERLINK interface parameters*)
		station	: USINT ;						(*station number: 0 for manager, 1...253 for controllers*)
		slot	: USINT ;						(*slot of the POWERLINK interface card*)
		subslot	: USINT ;						(*subslot of the POWERLINK interface card*)
		interface	: USINT ;					(*interface number*)
		pl_cycle	: UDINT ;					(*cycle time of a POWERLINK network cycle*)
		pl_prescale	: UDINT ;					(*prescaler for synchronous task classes*)
		uptimeout	: UDINT ;					(*timeout defining how long the wait should be when booting the slave*)
		bus	: USINT ;							(*bus number for this interface*)
		MuxStationsPerCycle	: USINT ;			(*number of multiplexed stations per POWERLINK cycle*)
		MuxPrescaler	: USINT ;				(*number of POWERLINK cycles for one mux cycle 1 .. 253*)
		ATOCtaskclass	: SINT ;				(*taskclass triggering the Output-DMA, 0 ..triggered by System-Tick, plCE_CYCLIC_1 to plCE_CYCLIC_8 ..triggered by cyclic taskklass*)
		reservedlong	: UDINT ;				(*reserved*)
	END_STRUCT;	
	PLSYSCONF_typ : STRUCT						(*configuration structure which must be transferred to plConfig*)
		noIF	: USINT ;						(*number of interface cards*)
		takt_master	: USINT ;					(*specifies which interface card should trigger the synchronous timer2 task class*)
		reserve1	: UINT ;					(*reserved for future use (should always be set to 0)*)
		pRemoteCfg	: UDINT ;					(*pointer to an array with remote station configurations*)
		interfaces	: ARRAY[0..14] OF PLSYSCONF_IF_typ ;	(*interface configurations*)
	END_STRUCT;
END_TYPE